/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep.character;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.align.Aligner;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.align.IDescMap;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescMultiSet;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.property.BooleanPropertyDescriptor;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.character.AlignedText;
import edu.mit.story.core.rep.character.CharAligner;
import edu.mit.story.core.rep.character.CharStore;
import edu.mit.story.core.rep.character.IAlignedText;
import edu.mit.story.core.rep.character.ICharStore;
import edu.mit.story.core.rep.character.IOffset;
import edu.mit.story.core.rep.character.Offset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.text.ITextStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharRep
extends AbstractRep {
    public static final String PARAM_EDITABLE = "editable";
    private static final long serialVersionUID = 1L;
    private static IRep fInstance = null;

    public static IRep getInstance() {
        if (fInstance == null) {
            fInstance = StoryPlugin.getDefault().getRepManager().getRep("edu.mit.story.char");
        }
        return fInstance;
    }

    public CharRep() {
        super(ICharStore.class);
    }

    @Override
    protected void initAntecedentsInternal(IRepSet container) {
    }

    @Override
    public String serialize(IData data) {
        ICharStore store = (ICharStore)data;
        StringBuilder sb = new StringBuilder(store.getLength() + 2);
        sb.append('\n');
        sb.append(store.get(0, store.getLength()));
        sb.append('\n');
        return sb.toString();
    }

    @Override
    public CharStore reconstitute(IHasPosition p, String data, IStoryModel provider) {
        CharStore store = new CharStore();
        int last = data.length() - 1;
        if (p.getLength() + 2 == data.length() && data.charAt(0) == '\n' && data.charAt(last) == '\n') {
            data = data.substring(1, last);
        }
        store.set(data);
        return store;
    }

    @Override
    public int getIndexLength(IStoryData data) {
        if (!data.supports(this)) {
            return 0;
        }
        ICharStore store = CharRep.extractCharStore(data);
        if (store == null) {
            return 0;
        }
        return store.getLength();
    }

    @Override
    public boolean isTransferable() {
        return false;
    }

    @Override
    public IDescMap align(IDescSet source, IDescSet target, IAlignedStoryModel model) {
        throw new UnsupportedOperationException();
    }

    public static String getChars(IHasPosition range, IStoryModel provider) {
        ICharStore store = CharRep.extractCharStore(provider.getData());
        if (store == null | range.getRightOffset() <= range.getOffset()) {
            return "";
        }
        int length = Math.min(range.getLength(), store.getLength() - range.getOffset());
        return store.get(range.getOffset(), length);
    }

    public static ICharStore extractCharStore(Collection<? extends IDesc> c) {
        return CharRep.extractCharStore(CharRep.extractCharDescription(c));
    }

    public static IDesc extractCharDescription(Collection<? extends IDesc> c) {
        if (c instanceof IDescMultiSet) {
            IDescSet descSet = ((IDescMultiSet)c).getDescriptions(CharRep.getInstance());
            if (descSet == null) {
                return null;
            }
            if (descSet.size() != 1) {
                return null;
            }
            return (IDesc)descSet.first();
        }
        if (c instanceof IDescSet) {
            IDescSet descSet = (IDescSet)c;
            if (!descSet.getRep().equals(CharRep.getInstance())) {
                return null;
            }
            if (descSet.size() != 1) {
                return null;
            }
            return (IDesc)descSet.first();
        }
        IDesc found = null;
        for (IDesc iDesc : c) {
            if (!iDesc.getRep().equals(CharRep.getInstance())) continue;
            if (found != null) {
                return null;
            }
            found = iDesc;
        }
        return found;
    }

    public static ICharStore extractCharStore(IDesc desc) {
        if (desc == null) {
            return null;
        }
        IData data = desc.getData();
        return data instanceof ICharStore ? (ICharStore)data : null;
    }

    @Override
    protected IConfigDescriptor createConfigurationDescriptor(String id, String name, String desc) {
        return new CharRepConfigDescriptor(id, name, desc);
    }

    public static IAlignedText align(ITextStore source, ITextStore target) {
        int srcLen = source.getLength();
        int tgtLen = target.getLength();
        ArrayList<Offset> srcOffs = new ArrayList<Offset>(srcLen);
        ArrayList<Offset> tgtOffs = new ArrayList<Offset>(tgtLen);
        int i = 0;
        while (i < srcLen) {
            srcOffs.add(new Offset(source.get(i), i));
            ++i;
        }
        i = 0;
        while (i < tgtLen) {
            tgtOffs.add(new Offset(target.get(i), i));
            ++i;
        }
        List<Aligner.Pair<IOffset, IOffset>> alignment = CharAligner.getInstance().align(srcOffs, tgtOffs);
        return new AlignedText(source, target, alignment);
    }

    public static class CharRepConfigDescriptor
    extends ConfigDescriptor {
        private static final long serialVersionUID = 1L;

        public CharRepConfigDescriptor(String id, String name, String desc) {
            this();
            this.setID(id);
            this.setName(name);
            this.setDescription(desc);
        }

        public CharRepConfigDescriptor() {
            BooleanPropertyDescriptor d = new BooleanPropertyDescriptor(CharRep.PARAM_EDITABLE, "Editable Text", "Whether the text of the model is editable", true);
            this.put(d.getID(), d);
        }
    }
}

