/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.validation;

import edu.mit.story.core.IStoryConstants;
import edu.mit.story.core.validation.IListValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanValidator
implements IListValidator<String> {
    private static List<String> values;

    static {
        ArrayList<String> hidden = new ArrayList<String>(2);
        hidden.add(Boolean.toString(true));
        hidden.add(Boolean.toString(false));
        values = Collections.unmodifiableList(hidden);
    }

    @Override
    public List<String> getValueList() {
        return values;
    }

    @Override
    public boolean isRestrictedToList() {
        return true;
    }

    @Override
    public IMessageProvider validate(String value) {
        if (value == null) {
            return IStoryConstants.noNullValues;
        }
        return this.isValid(value) ? null : IStoryConstants.invalidValue;
    }

    @Override
    public boolean isValid(String value) {
        for (String v : values) {
            if (!v.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowsInitialInvalidValue() {
        return false;
    }
}

