/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.archetype;

import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.semantics.core.rep.archetype.Archetype;
import edu.mit.semantics.core.rep.archetype.IArchetypalReferent;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IHasRep;

public class ArchetypalReferent
implements IArchetypalReferent {
    private final Archetype type;
    private final IDesc corefD;

    public ArchetypalReferent(Archetype type, IDesc corefD) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (!CorefRep.getInstance().isType((IHasRep)corefD)) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.corefD = corefD;
    }

    public Archetype getArchetype() {
        return this.type;
    }

    public IDesc getActor() {
        return this.corefD;
    }

    public IHasPosition calculatePosition() {
        return this.corefD;
    }

    public IHasPosition getDisplayPosition() {
        IStructuredData data = (IStructuredData)this.corefD.getData();
        return data.getDisplayPosition();
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        IDesc newCorefD = model.getData().getDescriptions(CorefRep.getInstance()).getDescription(this.corefD.getID());
        if (newCorefD == this.corefD) {
            return this;
        }
        if (newCorefD == null) {
            return null;
        }
        return new ArchetypalReferent(this.type, newCorefD);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        IArchetypalReferent that = (IArchetypalReferent)tgtData;
        if (this.getArchetype() != that.getArchetype()) {
            return false;
        }
        return Desc.equals((IDesc)this.getActor(), (IDesc)that.getActor(), (IAlignedStoryModel)model);
    }
}

