/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.context;

import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.semantics.core.rep.context.IContextArg;
import edu.mit.semantics.core.rep.context.IContextRole;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextArg
implements IContextArg {
    private final int group;
    private final int depth;
    private final IContextRole role;
    private final IDesc filler;

    public ContextArg(int group, IContextRole role, IDesc filler, int depth) {
        if (role == null) {
            throw new NullPointerException();
        }
        ContextArg.checkType(filler);
        depth = ContextArg.checkDepth(depth);
        this.group = group = ContextArg.checkGroup(group);
        this.role = role;
        this.depth = depth;
        this.filler = filler;
    }

    public static IDesc checkType(IDesc desc) {
        if (desc.getRep() == EventRep.getInstance()) {
            return desc;
        }
        if (desc.getRep() == RefExpRep.getInstance()) {
            return desc;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getExclusionGroup() {
        return this.group;
    }

    @Override
    public IContextRole getRole() {
        return this.role;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public IDesc getFiller() {
        return this.filler;
    }

    public int getLength() {
        return this.filler.getLength();
    }

    public int getOffset() {
        return this.filler.getOffset();
    }

    public int getRightOffset() {
        return this.filler.getRightOffset();
    }

    public IHasPosition calculatePosition() {
        return this.filler;
    }

    public IHasPosition getDisplayPosition() {
        return this.filler;
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        IDesc newFiller = model.getData().getDescriptions(this.filler.getRep()).getDescription(this.filler.getID());
        if (newFiller == null) {
            return null;
        }
        if (newFiller == this.filler) {
            return this;
        }
        return new ContextArg(this.group, this.role, newFiller, this.depth);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (!(tgtData instanceof IContextArg)) {
            return false;
        }
        IContextArg tgtArg = (IContextArg)tgtData;
        if (!this.role.equals(tgtArg.getRole())) {
            return false;
        }
        if (this.depth != tgtArg.getDepth()) {
            return false;
        }
        return this.filler.equals(tgtArg.getFiller(), model);
    }

    public static boolean equals(IContextArg srcArg, IContextArg tgtArg, IAlignedStoryModel model) {
        if (srcArg == tgtArg) {
            return true;
        }
        if (srcArg == null || tgtArg == null) {
            return false;
        }
        return srcArg.equals((IData)tgtArg, model);
    }

    public static boolean equals(Collection<? extends IContextArg> srcArgs, Collection<? extends IContextArg> tgtArgs, IAlignedStoryModel model) {
        if (srcArgs == tgtArgs) {
            return true;
        }
        if (srcArgs.size() != tgtArgs.size()) {
            return false;
        }
        Iterator<? extends IContextArg> srcItr = srcArgs.iterator();
        Iterator<? extends IContextArg> tgtItr = tgtArgs.iterator();
        while (srcItr.hasNext() && tgtItr.hasNext()) {
            if (ContextArg.equals(srcItr.next(), tgtItr.next(), model)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalDepth(int depth) {
        return depth >= 0;
    }

    public static int checkDepth(int depth) {
        if (!ContextArg.isLegalDepth(depth)) {
            throw new IllegalArgumentException("Depth must be zero or positive");
        }
        return depth;
    }

    public static boolean isLegalGroup(int group) {
        return group >= 0;
    }

    public static int checkGroup(int group) {
        if (!ContextArg.isLegalDepth(group)) {
            throw new IllegalArgumentException("Group must be zero or positive");
        }
        return group;
    }
}

