/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.context.rules;

import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.rep.context.ContextRelationRep;
import edu.mit.semantics.core.rep.context.IContextRelation;
import edu.mit.semantics.core.rep.context.problems.UnusedContextSignalProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseContextSignalsRule
extends AbstractBuildRule {
    public static final String ID = UseContextSignalsRule.class.getCanonicalName();
    public static final Set<String> possessives = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("my", "mine", "your", "yours", "his", "hers", "its", "our", "ours", "their", "theirs", "whose", "'s")));

    public UseContextSignalsRule() {
        super(ContextRelationRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        if (!model.supports(ContextRelationRep.getInstance())) {
            return null;
        }
        DescSet foundSignals = new DescSet(TokenRep.getInstance());
        for (IDesc d : model.getData().getDescriptions(TokenRep.getInstance())) {
            IToken t = (IToken)d.getData();
            if (!possessives.contains(t.getSurface().toLowerCase())) continue;
            foundSignals.add((Object)d);
        }
        for (IDesc d : model.getData().getDescriptions(ContextRelationRep.getInstance())) {
            IContextRelation rel = (IContextRelation)d.getData();
            if (rel.getSignal() == null) continue;
            foundSignals.removeAll((Collection)rel.getSignal().getDescs());
        }
        Iterator i = foundSignals.iterator();
        while (i.hasNext()) {
            if (!CheckMetaRep.isChecked((IDesc)((IDesc)i.next()), (String)"edu.mit.semantics.context.problem.unusedContextSignal")) continue;
            i.remove();
        }
        if (foundSignals.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc d : foundSignals) {
            result.add((Object)new UnusedContextSignalProblem(d, this.getID()));
        }
        return result;
    }
}

