/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event;

import edu.mit.story.core.descriptor.IHasDescription;
import edu.mit.story.core.descriptor.IHasName;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EventClass implements IHasName,
IHasDescription
{
    UNSPECIFIED("Unspecified", "An event whose class has not yet been specified", new String[0]),
    OCCURRENCE("Occurrence", "Something that happens or occurs in the world", new String[0]),
    STATE("State", "A circumstance in which something obtains or holds true", new String[0]),
    PERCEPTION("Perception", "An event involving physical perception of another event", "see", "watch", "glimpse", "behold", "view", "hear", "listen", "overhear"),
    REPORTING("Reporting", "An action where a person or organization declares, narrates, or informs about another event", "say", "report", "tell", "explain", "state"),
    ASPECTUAL("Aspectual", "A predicate that focuses on different facets of event history", "begin", "start", "restart", "stop", "end", "finish", "complete", "continue", "persevere"),
    I_ACTION("Intensional Action", "An action that governs an explicit event about which we can infer something given its relation to the intensional action", "attempt", "try", "investigate", "delay", "hinder", "avoid", "ask", "order", "vow", "claim", "allege"),
    I_STATE("Intensional State", "A state that refers to alternative or possible worlds", "believe", "think", "suspect", "want", "hope", "expect", "demand"),
    UNKNOWN("Unknown", "An unknown event type", new String[0]);

    private final String name;
    private final String desc;
    private final List<String> examples;

    private EventClass(String name, String desc, String ... examples) {
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (desc.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.desc = desc;
        this.examples = Collections.unmodifiableList(Arrays.asList(examples));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.desc;
    }

    public List<String> getExamples() {
        return this.examples;
    }
}

