/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.move;

import edu.mit.semantics.core.rep.function.FunctionRep;
import edu.mit.semantics.core.rep.move.IMove;
import edu.mit.semantics.core.rep.move.Move;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.mappers.DescriptionMapper;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.Version;

public class MoveRep
extends AbstractRep {
    public static final String ID = "edu.mit.semantics.rep.move";
    private static IRep instance = null;

    public static IRep getInstance() {
        if (instance == null) {
            instance = StoryPlugin.getDefault().getRepManager().getRep(ID);
        }
        return instance;
    }

    public MoveRep() {
        super(IMove.class, v01, 0);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)FunctionRep.getInstance());
    }

    public String serialize(IData data) {
        IMove move = (IMove)data;
        LinkedList<String> fields = new LinkedList<String>();
        fields.add(Integer.toString(move.getNumber()));
        fields.add(DescriptionMapper.toValueStatic(move.getFunctions()));
        return BlockMapper.PIPE.serialize(fields);
    }

    public IData reconstitute(IHasPosition p, String description, IStoryModel model) {
        return this.reconstitute(p, description, model, this.getVersion());
    }

    public IData reconstitute(IHasPosition p, String description, IStoryModel model, Version version) {
        if (v01.equals((Object)version)) {
            return this.reconstituteVer01(p, description, model);
        }
        return this.reconstitute(p, description, model, this.getVersion());
    }

    protected final IData reconstituteVer01(IHasPosition p, String description, IStoryModel model) {
        List fields = BlockMapper.PIPE.reconstitute(description);
        DescriptionMapper mapper = new DescriptionMapper(model.getData());
        int number = Integer.parseInt((String)fields.get(0));
        List functions = mapper.reconstitute((String)fields.get(1));
        return new Move(number, functions);
    }
}

