/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timex3;

import edu.mit.semantics.core.rep.timex3.ITimex3;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Data;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Timex3
implements ITimex3 {
    private final ISegmentSet expression;
    private final ITimex3.Type type;
    private final ITimex3.Mod mod;
    private final ITimex3.Function func;
    private final ISegmentSet quant;
    private final ISegmentSet freq;
    private final String value;
    private final boolean isTempFunc = false;

    public Timex3(Collection<? extends ISegment> segments, ITimex3.Type type, ITimex3.Mod mod, ITimex3.Function func, Collection<? extends ISegment> quant, Collection<? extends ISegment> freq) {
        this.value = null;
        if (type == null) {
            throw new NullPointerException();
        }
        if (mod == null) {
            throw new NullPointerException();
        }
        if (func == null) {
            throw new NullPointerException();
        }
        this.expression = new SegmentSet(segments);
        this.type = type;
        this.mod = mod;
        this.func = func;
        this.quant = quant == null || quant.isEmpty() ? null : new SegmentSet(quant);
        SegmentSet segmentSet = this.freq = freq == null || freq.isEmpty() ? null : new SegmentSet(freq);
        if ((this.quant != null || this.freq != null) && type != ITimex3.Type.SET) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public ISegmentSet getExpression() {
        return this.expression;
    }

    @Override
    public ITimex3.Type getType() {
        return this.type;
    }

    @Override
    public ITimex3.Function getFunction() {
        return this.func;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public ISegmentSet getQuantifier() {
        return this.quant;
    }

    @Override
    public ISegmentSet getFrequency() {
        return this.freq;
    }

    @Override
    public ITimex3.Mod getModifier() {
        return this.mod;
    }

    @Override
    public boolean isTemporalFunction() {
        return false;
    }

    public IHasPosition calculatePosition() {
        return this.expression;
    }

    public IHasPosition getDisplayPosition() {
        return this.calculatePosition();
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        ISegmentSet newExpression = (ISegmentSet)this.expression.recalculate(container, model);
        if (newExpression == null) {
            return null;
        }
        ISegmentSet newQuant = null;
        if (this.quant != null) {
            newQuant = (ISegmentSet)this.quant.recalculate(container, model);
        }
        ISegmentSet newFreq = null;
        if (this.freq != null) {
            newFreq = (ISegmentSet)this.freq.recalculate(container, model);
        }
        boolean changed = false;
        changed |= this.expression != newExpression;
        changed |= this.quant != newQuant;
        if (!(changed |= this.freq != newFreq)) {
            return this;
        }
        return new Timex3((Collection<? extends ISegment>)newExpression, this.type, this.mod, this.func, (Collection<? extends ISegment>)newQuant, (Collection<? extends ISegment>)newFreq);
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        if (this == tgtData) {
            return true;
        }
        if (!ITimex3.class.isAssignableFrom(tgtData.getClass())) {
            return false;
        }
        ITimex3 tgtTimex = (ITimex3)tgtData;
        if (!this.type.equals((Object)tgtTimex.getType())) {
            return false;
        }
        if (!this.mod.equals((Object)tgtTimex.getModifier())) {
            return false;
        }
        if (!this.func.equals((Object)tgtTimex.getFunction())) {
            return false;
        }
        if (!Data.equals((IData)this.quant, (IData)tgtTimex.getQuantifier(), (IAlignedStoryModel)model)) {
            return false;
        }
        return Data.equals((IData)this.freq, (IData)tgtTimex.getFrequency(), (IAlignedStoryModel)model);
    }
}

