/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timex3;

import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.rep.timex3.ITimex3;
import edu.mit.semantics.core.rep.timex3.Timex3;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.SegmentMapper;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class Timex3Rep
extends AbstractRep {
    public static final String ID = "edu.mit.semantics.timex3";
    public static final Pattern keyValueRegex = Pattern.compile("(\\S+)=\"(\\S+)\"$");
    private static IRep fInstance = null;

    public static IRep getInstance() {
        if (fInstance == null) {
            fInstance = StoryPlugin.getDefault().getRepManager().getRep(ID);
        }
        return fInstance;
    }

    public Timex3Rep() {
        super(ITimex3.class);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)TokenRep.getInstance());
    }

    public String serialize(IData data) {
        ITimex3 timex = (ITimex3)data;
        LinkedList<String> fields = new LinkedList<String>();
        fields.add(timex.getType().name());
        fields.add(timex.getModifier().name());
        fields.add(SegmentMapper.serializeStatic((Collection)timex.getExpression()));
        fields.add(timex.getFunction().name());
        fields.add(SegmentMapper.serializeStatic((Collection)timex.getQuantifier()));
        fields.add(SegmentMapper.serializeStatic((Collection)timex.getFrequency()));
        return BlockMapper.PIPE.serialize(fields);
    }

    public Timex3 reconstitute(IHasPosition p, String data, IStoryModel model) {
        List fields = BlockMapper.PIPE.reconstitute(data);
        SegmentMapper mapper = new SegmentMapper(TokenRep.getInstance(), model.getData());
        ITimex3.Type type = ITimex3.Type.valueOf((String)fields.get(0));
        ITimex3.Mod mod = ITimex3.Mod.valueOf((String)fields.get(1));
        List exp = ((String)fields.get(2)).trim().length() == 0 ? Collections.emptyList() : mapper.reconstitute((String)fields.get(2));
        ITimex3.Function func = ITimex3.Function.valueOf((String)fields.get(3));
        List quant = ((String)fields.get(4)).trim().length() == 0 ? Collections.emptyList() : mapper.reconstitute((String)fields.get(4));
        List freq = ((String)fields.get(5)).trim().length() == 0 ? Collections.emptyList() : mapper.reconstitute((String)fields.get(5));
        return new Timex3(exp, type, mod, func, quant, freq);
    }
}

