/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.dialogs;

import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.parsing.ui.ParsingUIMessages;
import edu.mit.parsing.ui.ParsingUIPlugin;
import edu.mit.parsing.ui.label.WordLabelProvider;
import edu.mit.story.core.desc.DescComparator;
import edu.mit.story.core.desc.DescUtils;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.ui.editor.IHasStoryEditor;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = WordSelectionDialog.class.getCanonicalName();
    private Collection<? extends IDesc> words;

    public WordSelectionDialog(Shell parent, Collection<? extends IDesc> words) {
        super(parent);
        for (IDesc iDesc : words) {
            if (IBaseToken.class.isAssignableFrom(iDesc.getRep().getDataFormat())) continue;
            throw new IllegalArgumentException();
        }
        this.words = words;
        this.setInitialPattern("?");
        IHasStoryEditor iHasStoryEditor = new IHasStoryEditor(){

            public IStoryEditor getStoryEditor() {
                throw new UnsupportedOperationException();
            }

            public void setStoryEditor(IStoryEditor newEditor) {
                throw new UnsupportedOperationException();
            }
        };
        this.setListLabelProvider((ILabelProvider)new WordLabelProvider(iHasStoryEditor));
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new WordFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider targetCP, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor pm) throws CoreException {
        pm.beginTask("Searching...", this.words.size());
        for (IDesc iDesc : this.words) {
            targetCP.add((Object)iDesc, itemsFilter);
            pm.worked(1);
        }
        pm.done();
    }

    public String getElementName(Object item) {
        IDesc d = (IDesc)item;
        IBaseToken token = (IBaseToken)d.getData();
        return token.getSurface();
    }

    protected Comparator getItemsComparator() {
        return DescComparator.getInstance();
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = ParsingUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = ParsingUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    public static IDesc open(IStoryEditor editor) {
        return WordSelectionDialog.open(editor, null);
    }

    public static IDesc open(IStoryEditor editor, String title) {
        return WordSelectionDialog.open(editor, title, null);
    }

    public static IDesc open(IStoryEditor editor, String title, String message) {
        if (title == null) {
            title = ParsingUIMessages.DIALOG_SelectWord_title;
        }
        if (message == null) {
            message = ParsingUIMessages.DIALOG_SelectWord_msg;
        }
        if (!editor.getStoryModel().supports(TokenRep.getInstance())) {
            return null;
        }
        IHasPosition p = editor.getSelectedRange();
        HasPositionSet words = new HasPositionSet();
        words.addAll((Collection)DescUtils.getDescriptions((IHasPosition)p, (IDescSet)editor.getStoryModel().getData().getDescriptions(TokenRep.getInstance())));
        if (editor.getStoryModel().supports(CollocRep.getInstance())) {
            words.addAll((Collection)DescUtils.getDescriptions((IHasPosition)p, (IDescSet)editor.getStoryModel().getData().getDescriptions(CollocRep.getInstance())));
        }
        if (words.isEmpty()) {
            return null;
        }
        if (words.size() == 1) {
            return (IDesc)words.first();
        }
        WordSelectionDialog dialog = new WordSelectionDialog(editor.getSite().getShell(), (Collection<? extends IDesc>)words);
        dialog.setBlockOnOpen(true);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        return (IDesc)result[0];
    }

    protected class WordFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public WordFilter() {
            super((FilteredItemsSelectionDialog)WordSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return false;
        }

        public boolean matchItem(Object item) {
            if (item instanceof IDesc) {
                return this.matchDesc((IDesc)item);
            }
            return false;
        }

        protected boolean matchDesc(IDesc desc) {
            IBaseToken token = (IBaseToken)desc.getData();
            return this.matches(token.getSurface()) || this.matches(token.getToken());
        }
    }
}

