/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.content;

import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.stem.IStemData;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import java.util.LinkedList;
import java.util.TreeMap;

public class SenseContentProvider
extends StoryEditorContentProvider {
    private boolean sortingByStem = false;

    public SenseContentProvider(IStoryEditor editor) {
        super(SenseRep.getInstance(), editor, "(no senses)");
    }

    public boolean isSortingByStem() {
        return this.sortingByStem;
    }

    public void setSortByStem(boolean value) {
        if (this.sortingByStem == value) {
            return;
        }
        this.sortingByStem = value;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IDescSet) {
            return true;
        }
        return super.hasChildren(element);
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof IStoryModel) {
            IStoryModel model = (IStoryModel)parent;
            if (this.sortingByStem) {
                return this.getUniqueStems(model);
            }
            IDescSet descs = model.getData().getDescriptions(this.getRep());
            return this.getDescriptionClusters(descs);
        }
        if (parent instanceof StemDescSet) {
            return this.getDescriptionClusters((IDescSet)parent);
        }
        if (parent instanceof IDescSet) {
            IDescSet ds = (IDescSet)parent;
            return ds.toArray();
        }
        return super.getChildren(parent);
    }

    protected Object[] getDescriptionClusters(IDescSet parent) {
        if (!SenseRep.getInstance().isType((IHasRep)parent)) {
            throw new IllegalArgumentException();
        }
        LinkedList<Object> results = new LinkedList<Object>();
        IDesc last = null;
        for (IDesc d : parent) {
            if (last != null && PositionUtils.equalAsPositions((IHasPosition)last, (IHasPosition)d)) continue;
            last = d;
            IDescSet ds = parent.matchSet((IHasPosition)d);
            if (ds.size() == 1) {
                results.add(last);
                continue;
            }
            results.add(ds);
        }
        return results.toArray();
    }

    protected Object[] getUniqueStems(IStoryModel model) {
        TreeMap<String, StemDescSet> result = new TreeMap<String, StemDescSet>();
        for (IDesc d : model.getData().getDescriptions(SenseRep.getInstance())) {
            ISense sense = (ISense)d.getData();
            String key = String.valueOf(sense.getStem()) + "/" + sense.getTag().toGenericTag().getTagString() + "/" + Boolean.toString(sense.isAuxiliary());
            StemDescSet stemGroup = (StemDescSet)((Object)result.get(key));
            if (stemGroup == null) {
                stemGroup = new StemDescSet(sense.getStem(), (ITag)sense.getTag().toGenericTag(), sense.isAuxiliary());
                result.put(key, stemGroup);
            }
            stemGroup.add(d);
        }
        return result.values().toArray();
    }

    public static class StemDescSet
    extends DescSet
    implements IStemData,
    IPosData {
        private static final long serialVersionUID = 5445426350937823533L;
        private final String stem;
        private final ITag tag;
        private final boolean isAux;

        public StemDescSet(String stem, ITag tag, boolean isAux) {
            super(SenseRep.getInstance());
            if (stem.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            if (tag == null) {
                throw new NullPointerException();
            }
            this.stem = stem;
            this.tag = tag;
            this.isAux = isAux;
        }

        public String getStem() {
            return this.stem;
        }

        public ITag getTag() {
            return this.tag;
        }

        public boolean isAuxiliary() {
            return this.isAux;
        }
    }
}

