/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointData;
import org.eclipse.osgi.util.NLS;

public class CollectAction
extends ProvisioningAction {
    public static final String ID = "collect";
    public static final String ARTIFACT_FOLDER = "artifact.folder";

    public IStatus execute(Map parameters) {
        IArtifactRequest[] requests;
        IProfile profile = (IProfile)parameters.get("profile");
        InstallableUnitOperand operand = (InstallableUnitOperand)parameters.get("operand");
        try {
            requests = CollectAction.collect(operand.second(), profile);
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        Collection artifactRequests = (Collection)parameters.get("artifactRequests");
        artifactRequests.add(requests);
        return Status.OK_STATUS;
    }

    public IStatus undo(Map parameters) {
        return Status.OK_STATUS;
    }

    public static boolean isZipped(TouchpointData[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        int i = 0;
        while (i < data.length) {
            if (data[i].getInstructions("zipped") != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Properties createArtifactDescriptorProperties(IInstallableUnit installableUnit) {
        Properties descriptorProperties = null;
        if (CollectAction.isZipped(installableUnit.getTouchpointData())) {
            descriptorProperties = new Properties();
            descriptorProperties.setProperty(ARTIFACT_FOLDER, Boolean.TRUE.toString());
        }
        return descriptorProperties;
    }

    public static IArtifactRequest[] collect(IInstallableUnit installableUnit, IProfile profile) throws ProvisionException {
        IArtifactKey[] toDownload = installableUnit.getArtifacts();
        if (toDownload == null || toDownload.length == 0) {
            return IArtifactRepositoryManager.NO_ARTIFACT_REQUEST;
        }
        IFileArtifactRepository aggregatedRepositoryView = Util.getAggregatedBundleRepository(profile);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository(profile);
        if (bundlePool == null) {
            throw new ProvisionException(Util.createError(NLS.bind((String)Messages.no_bundle_pool, (Object)profile.getProfileId())));
        }
        ArrayList<IArtifactRequest> requests = new ArrayList<IArtifactRequest>();
        int i = 0;
        while (i < toDownload.length) {
            IArtifactKey key = toDownload[i];
            if (!aggregatedRepositoryView.contains(key)) {
                Properties repositoryProperties = CollectAction.createArtifactDescriptorProperties(installableUnit);
                requests.add(Util.getArtifactRepositoryManager().createMirrorRequest(key, (IArtifactRepository)bundlePool, null, repositoryProperties));
            }
            ++i;
        }
        if (requests.isEmpty()) {
            return IArtifactRepositoryManager.NO_ARTIFACT_REQUEST;
        }
        IArtifactRequest[] result = requests.toArray(new IArtifactRequest[requests.size()]);
        return result;
    }
}

