/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.validation;

import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.Message;
import edu.mit.wordnet.core.WordnetMessages;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectIDValidator
implements IValidator<String> {
    public static final String DEFAULT_ID = "00119215";
    private static SubjectIDValidator instance;
    private static final IMessageProvider noNulls;
    private static final IMessageProvider eightDigits;

    static {
        noNulls = new Message(WordnetMessages.MSG_Problem_SubjectNumber_CannotBeNull, 3);
        eightDigits = new Message(WordnetMessages.MSG_Problem_SubjectNumber_MustBeEightDigits, 3);
    }

    public static SubjectIDValidator getInstance() {
        if (instance == null) {
            instance = new SubjectIDValidator();
        }
        return instance;
    }

    protected SubjectIDValidator() {
    }

    public IMessageProvider validate(String id) {
        if (id == null) {
            return noNulls;
        }
        if (id.length() != 8) {
            return eightDigits;
        }
        int i = 0;
        while (i < id.length()) {
            if (!Character.isDigit(id.charAt(i))) {
                return eightDigits;
            }
            ++i;
        }
        try {
            if (this.isValid(id)) {
                return null;
            }
        }
        catch (Exception exception) {}
        String msg = NLS.bind((String)WordnetMessages.MSG_Problem_SubjectNumber_NotAValidID, (Object)id);
        return new Message(msg, 3);
    }

    public boolean isValid(String id) throws NumberFormatException {
        int n1 = Integer.parseInt(Character.toString(id.charAt(0)));
        int n2 = Integer.parseInt(Character.toString(id.charAt(1)));
        int n3 = Integer.parseInt(Character.toString(id.charAt(2)));
        int n = n1 * 100 + n2 * 10 + n3;
        int expectedMod = Integer.parseInt(id.substring(3));
        int p = 7;
        int h = p + n;
        h = h * p + n1;
        h = h * p + n2;
        h = h * p + n3;
        int m = (h *= p) % 99991;
        return m == expectedMod;
    }

    public boolean allowsInitialInvalidValue() {
        return false;
    }
}

