/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;

public class IntTaggedWord
implements Serializable,
Comparable {
    private static Numberer wordNumberer;
    private static Numberer tagNumberer;
    public int word;
    public short tag;
    public static final String ANY = ".*.";
    public static final String STOP = "STOP";
    static final char[] charsToEscape;
    private static final long serialVersionUID = 1L;

    Numberer wordNumberer() {
        if (wordNumberer == null) {
            wordNumberer = Numberer.getGlobalNumberer("words");
        }
        return wordNumberer;
    }

    Numberer tagNumberer() {
        if (tagNumberer == null) {
            tagNumberer = Numberer.getGlobalNumberer("tags");
        }
        return tagNumberer;
    }

    static void resetNumberers() {
        wordNumberer = null;
        tagNumberer = null;
    }

    public int tag() {
        return this.tag;
    }

    public int word() {
        return this.word;
    }

    public String wordString() {
        String wordStr = this.word >= 0 ? (String)this.wordNumberer().object(this.word) : (this.word == -1 ? ANY : STOP);
        return wordStr;
    }

    public String tagString() {
        String tagStr = this.tag >= 0 ? (String)this.tagNumberer().object(this.tag) : (this.tag == -1 ? ANY : STOP);
        return tagStr;
    }

    public int hashCode() {
        return this.word ^ this.tag << 16;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IntTaggedWord) {
            IntTaggedWord i = (IntTaggedWord)o;
            return this.word == i.word && this.tag == i.tag;
        }
        return false;
    }

    public int compareTo(Object obj) {
        IntTaggedWord that = (IntTaggedWord)obj;
        if (this.tag != that.tag) {
            return this.tag - that.tag;
        }
        return this.word - that.word;
    }

    public String toLexicalEntry() {
        String wordStr = this.wordString();
        String tagStr = this.tagString();
        return "\"" + StringUtils.escapeString(tagStr, charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(wordStr, charsToEscape, '\\') + "\"";
    }

    public String toString() {
        return this.wordString() + "/" + this.tagString();
    }

    public String toString(String arg) {
        if (arg.equals("verbose")) {
            return this.wordString() + "[" + this.word + "]/" + this.tagString() + "[" + this.tag + "]";
        }
        return this.toString();
    }

    public IntTaggedWord(int word, int tag) {
        this.word = word;
        this.tag = (short)tag;
    }

    public TaggedWord toTaggedWord() {
        String wordStr = this.wordString();
        String tagStr = this.tagString();
        return new TaggedWord(wordStr, tagStr);
    }

    public IntTaggedWord(String s, char splitChar) {
        this(IntTaggedWord.extractWord(s, splitChar), IntTaggedWord.extractTag(s, splitChar));
    }

    private static String extractWord(String s, char splitChar) {
        int n = s.lastIndexOf(splitChar);
        String result = s.substring(0, n);
        return result;
    }

    private static String extractTag(String s, char splitChar) {
        int n = s.lastIndexOf(splitChar);
        String result = s.substring(n + 1);
        return result;
    }

    public IntTaggedWord(String wordString, String tagString) {
        int word = wordString.equals(ANY) ? -1 : (wordString.equals(STOP) ? -2 : this.wordNumberer().number(wordString));
        int tag = tagString.equals(ANY) ? -1 : (wordString.equals(STOP) ? -2 : this.tagNumberer().number(tagString));
        this.word = word;
        this.tag = (short)tag;
    }

    static {
        charsToEscape = new char[]{'\"'};
    }
}

