/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.CategoryWordTagFactory;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;

class TreeNullAnnotator
implements TreeTransformer {
    private TreeFactory tf = new LabeledScoredTreeFactory(new CategoryWordTagFactory());
    private HeadFinder hf;

    public Tree transformTree(Tree t) {
        Tree copy = t.deepCopy(this.tf);
        return this.transformTreeHelper(copy);
    }

    private Tree transformTreeHelper(Tree t) {
        if (t != null) {
            String cat = t.label().value();
            if (t.isLeaf()) {
                StringLabel label = new StringLabel(cat);
                t.setLabel(label);
            } else {
                String tag;
                String word;
                Tree[] kids = t.children();
                for (int childNum = 0; childNum < kids.length; ++childNum) {
                    Tree child = kids[childNum];
                    this.transformTreeHelper(child);
                }
                Tree headChild = this.hf.determineHead(t);
                if (headChild == null) {
                    System.err.println("ERROR: null head for tree\n" + t.toString());
                    word = null;
                    tag = null;
                } else if (headChild.isLeaf()) {
                    tag = cat;
                    word = headChild.label().value();
                } else {
                    CategoryWordTag headLabel = (CategoryWordTag)headChild.label();
                    word = headLabel.word();
                    tag = headLabel.tag();
                }
                CategoryWordTag label = new CategoryWordTag(cat, word, tag);
                t.setLabel(label);
            }
        }
        return t;
    }

    public TreeNullAnnotator(HeadFinder hf) {
        this.hf = hf;
    }
}

