/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.TestSentence;

class ExtractorFollowingNN
extends Extractor {
    static Extractor nextWord = new Extractor(1, false);
    static String thatWord = TestSentence.toSt("that");
    static String nnTag = TestSentence.toSt("NN");
    static String nnsTag = TestSentence.toSt("NNS");
    static String nnpTag = TestSentence.toSt("NNP");
    static String nnpsTag = TestSentence.toSt("NNPS");

    public boolean Precondition(String tag) {
        return true;
    }

    String extract(History h) {
        String cword = ExtractorFrames.cWord.extract(h);
        String nWord = nextWord.extract(h);
        if (!cword.equals(thatWord)) {
            return "0";
        }
        if (nWord.startsWith("NA")) {
            return "0";
        }
        if (ExtractorFollowingNN.isNSCount(nWord)) {
            return "1";
        }
        return "0";
    }

    public static boolean isNSCount(String word) {
        String word1;
        return GlobalHolder.dict.getCount(word, nnTag) > 0 && GlobalHolder.dict.getCount(word1 = TestSentence.toSt(String.valueOf(TestSentence.toNice(word)) + "s"), nnsTag) > 0;
    }
}

