/* Filename: ScoredDiscourse.java
 * Author: Andrew B. Shapiro
 * Format: Java 2 v1.5.0
 * Date created: Aug 9, 2008
 */
package edu.mit.discourse.core.compare;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * A <code>ScoredElement</code> associates an unmodifiable <code>double</code>
 * score with an unmodifiable <code>Map&lt;String,String,&gt;</code> of
 * domain-specific properties. <code>ScoredElement</code>'s may also keep
 * children <code>ScoredElement</code>'s.
 * 
 * @author Andrew B. Shapiro
 * @since 1.5.0 (Aug 9, 2008)
 */
public class ScoredElement extends AbstractScored implements IScoredElement {
	
	public final Map<String, String> properties;
	public final List<IScoredElement> children;

	public ScoredElement(double score, Map<String, String> properties) {
		this(score, properties, null);
	}

	public ScoredElement(double score, Map<String, String> properties, List<IScoredElement> children) {
		this.setScore(score);
		if (properties == null) {
			this.properties = Collections.emptyMap();
		} else {
			this.properties = Collections.unmodifiableMap(properties);
		}
		if (children == null) {
			this.children = Collections.emptyList();
		} else {
			this.children = Collections.unmodifiableList(children);
		}
	}

	/* (non-Javadoc) @see edu.mit.discourse.core.compare.IScoredElement#hasChildren() */
	public boolean hasChildren() {
		return this.children != null && !this.children.isEmpty();
	}

	/* (non-Javadoc) @see edu.mit.discourse.core.compare.IScoredElement#getProperty(java.lang.String) */
	public String getProperty(String key) {
		if (key.equals(KEY_Score)) return String.valueOf(this.getScore());
		return this.properties.get(key);
	}

}
