/* Filename: OneIndicationPerRefRule.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Jan 27, 2010
 */
package edu.mit.discourse.core.rep.referent.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Map.Entry;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.core.rep.referent.problems.DanglingAppositiveProblem;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.check.Check;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.meta.check.ICheck;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.util.EntryImpl;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.core 1.0.0
 */
public class IntegrateAppositivesRule extends AbstractBuildRule {
	
	public static final String ID = IntegrateAppositivesRule.class.getCanonicalName();
	
	public static final Set<String> tokensToIgnore = new HashSet<String>(Arrays.asList(
			"that", "who", "whose", "where", "which"
			));

	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @since nil.ucm.indications2.core 1.0.0
	 */
	public IntegrateAppositivesRule() {
		super(ReferentRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.build.IBuildRule#build(edu.mit.story.core.model.IStoryModel)
	 */
	public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
		
		IDescSet tokDescs = model.getData().getDescriptions(TokenRep.getInstance());
		IDescSet refDescs = model.getData().getDescriptions(ReferentRep.getInstance());

		List<Entry<IDesc, IReference>> appositives = new LinkedList<Entry<IDesc, IReference>>();
		
		// look for appositives
		IReferent referent;
		IReference last;
		IDesc lastToken, betweenToken, firstToken;
		String single;
		for(IDesc refDesc : refDescs){
			referent = (IReferent)refDesc.getData();
			
			last = null;
			inner:for(IReference ref : referent.getReferences()){
				
				// load up first reference into 'last'
				if(last == null){
					last = ref;
					continue;
				}
				
				// if the second reference is a single token
				// matching one in our ignore list, ignore it
				firstToken = ref.getSegments().first().getDescs().first();
				if(ref.getSegments().size() == 1 && ref.getSegments().first().getDescs().size() == 1){
					single = ((IToken)firstToken.getData()).getSurface().toLowerCase();
					if(tokensToIgnore.contains(single)) continue;
				}
				
				// compare last and current.  If they are
				// not separated by any tokens, or only by a 
				// single comma, mark as possible problem
				lastToken = last.getSegments().last().getDescs().last();
				betweenToken = null;
				for(IDesc token : tokDescs.tailSet(lastToken)){
					// ignore the last token of the reference
					if(token == lastToken) continue;
					// break when we arrive at the first token
					if(token == firstToken) break;
					// capture the between token, if any
					if(betweenToken == null){
						betweenToken = token;
						continue;
					}
					// if we ever get here, there are more
					// than two tokens between the references
					// so the second is not an appositive
					continue inner;
				}
				
				if(betweenToken == null || ((IToken)betweenToken.getData()).getSurface().equals(",")){
					appositives.add(new EntryImpl<IDesc, IReference>(refDesc, ref));
				}
				
				last = ref;
			}
		}
		
		// remove checked items
		String checkPrefix = DanglingAppositiveProblem.ID + ':';
		String check;
		IMetaDataSet<ICheck> checks;
		Entry<IDesc, IReference> appositive;
		for(Iterator<Entry<IDesc, IReference>> i = appositives.iterator(); i.hasNext(); ){
			appositive = i.next(); 
			check = checkPrefix + Integer.toString(appositive.getValue().getID());
			checks = appositive.getKey().getMetaData().get(CheckMetaRep.getInstance());
			if(checks.contains(new MetaDesc<ICheck>(CheckMetaRep.getInstance(), appositive.getKey(), new Check(check))))
					i.remove();
		}
		
		// do problems
		IHasPositionSet<IStoryProblem> result = new HasPositionSet<IStoryProblem>();
		StoryProblem p;
		int id;
		for(Entry<IDesc, IReference> problem : appositives){
			id = problem.getValue().getID();
			p = new DanglingAppositiveProblem(problem.getKey(), problem.getValue().getID(), ID);
			p.setCheck(DanglingAppositiveProblem.ID + ':' + Integer.toString(id));
			result.add(p);
		}
		return result;
	}

}
















