/* Filename: SelectFoldersDialog.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Feb 4, 2010
 */
package nil.ucm.indications2.ui.dialogs;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.ui 1.0.0
 */
public class SelectResourceDialog extends StatusDialog {
	
	protected final int typeMask;
	protected final int lowestType;
	protected final String typeStr;
	
	protected Label oneLabel;
	protected Text oneText;
	protected IResource one;

	/**
	 * TODO: Write comment
	 *
	 * @param parent
	 * @param type one of IResource.FILE, IResource.FOLDER, or IRESOURCE.PROJECT
	 * @since nil.ucm.indications2.ui 1.0.0
	 */
	public SelectResourceDialog(Shell parent, int typeMask) {
		super(parent);
		this.typeMask = typeMask;
		this.lowestType = ((typeMask&IResource.FILE)>0) ? IResource.FILE : ((typeMask&IResource.FOLDER)>0) ? IResource.FOLDER : IResource.PROJECT;
		this.typeStr = getTypeString();
	}
	
	public IResource getResourceOne(){
		return one;
	}
	
	/* 
	 * (non-Javadoc) @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		 Composite composite = (Composite)super.createDialogArea(parent);
		 GridLayout layout = (GridLayout)composite.getLayout();
		 layout.numColumns = 3;
		 
		 Button browse;
		 
		 // row for first
		 oneLabel = new Label(composite, SWT.NONE);
		 oneLabel.setText("Target");
		 oneLabel.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false));
		 
		 oneText = new Text(composite, SWT.BORDER);
		 Point p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getSize();
		 GridData gd = new GridData(SWT.FILL, SWT.FILL, true, false);
		 gd.widthHint = p.x/3;
		 oneText.setLayoutData(gd);
		 oneText.setEditable(false);
		 oneText.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_LIST_BACKGROUND));
		 
		 browse = new Button(composite, SWT.PUSH);
		 browse.setText("&Browse...");
		 browse.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
		 browse.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				one = selectResource();
				updateControls();
			}
		 });

		 return composite;
	}
	
	protected IResource selectResource(){
		ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(getShell(), new WorkbenchLabelProvider(), new ResourceContentProvider());
		dialog.setTitle("Select a Story Project");
		dialog.setInput(ResourcesPlugin.getWorkspace());
		dialog.setAllowMultiple(false);
		dialog.setBlockOnOpen(true);
		int result = dialog.open();
		if(result == Dialog.CANCEL) return null;
		return (IResource)dialog.getFirstResult();
	}
	
	protected void updateControls(){
		
		String oneName = (one == null) ? "" : one.getFullPath().toOSString();
		
		if(!oneText.getText().equals(oneName)) oneText.setText(oneName); 
		
		if(checkType(one)){
			String type = getTypeString(one.getType());
			updateStatus(new Status(IStatus.OK, " ", "Press OK to analyze this " + type));
		} else {
			updateStatus(new Status(IStatus.ERROR, " ", "Select a " + typeStr + " to analyze"));
		}
	}
	
	protected boolean checkType(IResource r){
		if(r == null) return false;
		if(!r.isAccessible()) return false;
		return (r.getType() & typeMask) > 0;
	}
	
	/*
	 * @see org.eclipse.jface.dialogs.Dialog#isResizable()
	 * @since 3.4
	 */
	protected boolean isResizable() {
		return true;
	}
	
	protected String getTypeString(){
		
		List<String> strs = new LinkedList<String>();
		if((typeMask & IResource.FILE) > 0) strs.add(getTypeString(IResource.FILE));
		if((typeMask & IResource.FOLDER) > 0) strs.add(getTypeString(IResource.FOLDER));
		if((typeMask & IResource.PROJECT) > 0) strs.add(getTypeString(IResource.PROJECT));
		
		if(strs.size() == 1) return strs.get(0);
		if(strs.size() == 2) return strs.get(0) + " or " + strs.get(1);
		if(strs.size() == 3) return "resource";

		throw new IllegalStateException();
	}
	
	protected String getTypeString(int type){
		switch(type){
		case IResource.FILE: return "file";
		case IResource.FOLDER: return "folder";
		case IResource.PROJECT: return "project";
		default: return "resource";
		}
	}
	
	protected class ResourceContentProvider extends WorkbenchContentProvider {
		
		/* 
		 * (non-Javadoc) @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
		 */
		public Object[] getChildren(Object parent) {
			Object[] children = super.getChildren(parent);
			if(children.length == 0) return children;
			
			List<Object> results = new LinkedList<Object>();
			for(Object child : children){
				if(child instanceof IResource && ((IResource)child).getType() >= lowestType) results.add(child);
			}
			return results.toArray();
		}
		
	}
}
