/* Filename: UnknownIndicationTypeProblem.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 02/11/2009
 */
package nil.ucm.indications2.core.rep.problems;

import java.util.Collection;
import java.util.Collections;

import nil.ucm.indications2.core.rep.IIndicationStructure;
import nil.ucm.indications2.core.rep.IndicationStructureRep;

import org.eclipse.core.resources.IMarker;

import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;

/** 
 *   Problem for the indication descriptions that have as type UNKNOWN. 
 *
 * @author Raquel Hervas
 * @version 1.0, (Jan. 11, 2010)
 * @since nil.ucm.indications.core 1.0.0
 */
public class UnknownTypeProblem extends StoryProblem {
	
	public static final String ID = "nil.ucm.indications2.core.problem.unknownType";
	
	public UnknownTypeProblem(IDesc desc, String buildRuleID) {
		this(Collections.singleton(desc), buildRuleID);
	}

	public UnknownTypeProblem(Collection<? extends IDesc> descs, String buildRuleID) {
		super(IndicationStructureRep.getInstance(), buildRuleID);
		
		setID(ID);
		setName("constituent marked as unknown");
		setSeverity(IMarker.SEVERITY_ERROR);
		setDescs(descs);
		
		IDescSet ds = getDescs().getDescriptions(IndicationStructureRep.getInstance());
		if(ds.isEmpty()) throw new IllegalArgumentException();
		setPosition(ds.first());

		StringBuilder sb = new StringBuilder();
		if(ds.size() == 1){
			IIndicationStructure is = (IIndicationStructure)ds.first().getData();
			sb.append("The indication '");
			sb.append(is.getReference().getDisplayText());
			sb.append("' has at least one constituent marked as UNKNOWN");
		} else {
			sb.append("There are ");
			sb.append(Integer.toString(ds.size()));
			sb.append(" indications that constituents marked as UNKNOWN");
		}
		setDescription(sb.toString());
	}

}
