/* Filename: OneIndicationPerRefRule.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Jan 27, 2010
 */
package nil.ucm.indications2.core.rep.rules;

import java.util.HashSet;
import java.util.Set;

import nil.ucm.indications2.core.rep.IIndicationStructure;
import nil.ucm.indications2.core.rep.IndicationStructureRep;
import nil.ucm.indications2.core.rep.problems.MultipleIndicationsProblem;
import nil.ucm.indications2.core.rep.problems.UnindicatedReferenceProblem;
import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.core 1.0.0
 */
public class OneIndicationPerRefRule extends AbstractBuildRule {
	
	public static final String ID = OneIndicationPerRefRule.class.getCanonicalName();

	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @since nil.ucm.indications2.core 1.0.0
	 */
	public OneIndicationPerRefRule() {
		super(IndicationStructureRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.build.IBuildRule#build(edu.mit.story.core.model.IStoryModel)
	 */
	public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
		
		IDescSet refDescs = model.getData().getDescriptions(ReferentRep.getInstance());
		IDescSet indDescs = model.getData().getDescriptions(IndicationStructureRep.getInstance());
		
		// assemble set of references
		Set<IReference> noIndications = new HashSet<IReference>();
		IReferent referent;
		for(IDesc d : refDescs){
			referent = (IReferent)d.getData();
			noIndications.addAll(referent.getReferences());
		}
		
		// this will be our set of multiply-indicated references
		Set<IReference> multiple = new HashSet<IReference>();
		
		// iterate over all indications
		Set<IReference> hasIndications = new HashSet<IReference>();
		IIndicationStructure ind;
		IReference reference;
		for(IDesc d : indDescs){
			ind = (IIndicationStructure)d.getData();
			reference = ind.getReference();
			noIndications.remove(reference);
			if(hasIndications.remove(reference)){
				multiple.add(reference);
			} else {
				hasIndications.add(reference);
			}
		}
		
		IHasPositionSet<IStoryProblem> result = new HasPositionSet<IStoryProblem>();
		if(isCompressing()){
			if(!multiple.isEmpty()) result.add(new MultipleIndicationsProblem(multiple, ID));
			if(!noIndications.isEmpty()) result.add(new UnindicatedReferenceProblem(noIndications, ID));
		} else {
			for(IReference ref : multiple) result.add(new MultipleIndicationsProblem(ref, ID));
			for(IReference ref : noIndications) result.add(new UnindicatedReferenceProblem(ref, ID));
		}
		return result;
	}

}
