/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import org.tigris.subversion.subclipse.tools.usage.http.HttpMessages;
import org.tigris.subversion.subclipse.tools.usage.http.IHttpGetRequest;
import org.tigris.subversion.subclipse.tools.usage.tracker.ILoggingAdapter;

public class HttpGetRequest
implements IHttpGetRequest {
    private static final String USER_AGENT = "User-Agent";
    private static final String GET_METHOD_NAME = "GET";
    private ILoggingAdapter loggingAdapter = null;
    private String userAgent;

    public HttpGetRequest(String userAgent, ILoggingAdapter loggingAdapter) {
        this.userAgent = userAgent;
        this.loggingAdapter = loggingAdapter;
    }

    public void request(String urlString) {
        try {
            HttpURLConnection urlConnection = this.createURLConnection(urlString, this.userAgent);
            urlConnection.connect();
            int responseCode = this.getResponseCode(urlConnection);
            if (responseCode == 200) {
                Object[] parameters = new String[]{urlString, Integer.toString(responseCode)};
                this.loggingAdapter.logMessage(MessageFormat.format(HttpMessages.HttpGetMethod_Success, parameters));
            } else {
                Object[] parameters = new String[]{urlString};
                this.loggingAdapter.logError(MessageFormat.format(HttpMessages.HttpGetMethod_Error_Http, parameters));
            }
        }
        catch (Exception e) {
            Object[] parameters = new String[]{urlString, e.toString()};
            this.loggingAdapter.logMessage(MessageFormat.format(HttpMessages.HttpGetMethod_Error_Io, parameters));
        }
    }

    protected int getResponseCode(HttpURLConnection urlConnection) throws IOException {
        return urlConnection.getResponseCode();
    }

    protected HttpURLConnection createURLConnection(String urlString, String userAgent) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setInstanceFollowRedirects(true);
        urlConnection.setRequestMethod(GET_METHOD_NAME);
        urlConnection.setRequestProperty(USER_AGENT, userAgent);
        return urlConnection;
    }
}

