/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.semrole;

import edu.mit.jpropbank.ArgComparator;
import edu.mit.jpropbank.IArg;
import edu.mit.jpropbank.INode;
import edu.mit.jpropbank.IPredicateFeatures;
import edu.mit.jpropbank.PropbankEntryParser;
import edu.mit.jpropbank.frames.IRole;
import edu.mit.jpropbank.frames.IRoleset;
import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.parsing.core.rep.parse.ParseRep;
import edu.mit.semantics.core.SemanticsPlugin;
import edu.mit.semantics.core.propbank.GenericRoleSet;
import edu.mit.semantics.core.rep.semrole.GenerateSemroleModelChange;
import edu.mit.semantics.core.rep.semrole.ISemArg;
import edu.mit.semantics.core.rep.semrole.ISemRole;
import edu.mit.semantics.core.rep.semrole.SemRole;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SemRoleRep
extends AbstractRep {
    public static final String ID = "edu.mit.semantics.semroles";
    private static IRep fInstance = null;

    public static IRep getInstance() {
        if (fInstance == null) {
            fInstance = StoryPlugin.getDefault().getRepManager().getRep(ID);
        }
        return fInstance;
    }

    public SemRoleRep() {
        super(ISemRole.class, 1);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)ParseRep.getInstance());
    }

    public String serialize(IData data) {
        ISemRole semRole = (ISemRole)data;
        List args = semRole.getArguments();
        String[] fields = new String[args.size() + 4];
        fields[0] = Integer.toString(semRole.getTerminal());
        fields[1] = "user";
        IRoleset rs = semRole.getRoleset();
        fields[2] = rs == null ? "lemma.XX" : rs.getID();
        fields[3] = PropbankEntryParser.toString((IPredicateFeatures)semRole);
        int i = 0;
        while (i < args.size()) {
            fields[i + 4] = PropbankEntryParser.toString((IArg)((IArg)args.get(i)));
            ++i;
        }
        return BlockMapper.SPACE.serialize(Arrays.asList(fields));
    }

    public SemRole reconstitute(IHasPosition p, String description, IStoryModel model) {
        IDescSet parses = model.getData().getDescriptions(ParseRep.getInstance()).closedSet(p);
        if (parses.size() != 1) {
            return null;
        }
        IDesc parse = (IDesc)parses.first();
        ITree tree = (ITree)parse.getData();
        List fields = BlockMapper.SPACE.reconstitute(description);
        int terminal = Integer.parseInt((String)fields.get(0));
        String id = (String)fields.get(2);
        Object roleset = (IRoleset)SemanticsPlugin.getDefault().getFrameManager().getRoleSets().get(id);
        if (roleset == null) {
            roleset = GenericRoleSet.getInstance();
        }
        IPredicateFeatures fs = PropbankEntryParser.getInstance().parsePredicateFeatures((String)fields.get(3));
        List args = PropbankEntryParser.getInstance().parseArguments(4, fields.toArray(new String[fields.size()]));
        ArrayList<ISemArg> treeArgs = new ArrayList<ISemArg>(args.size());
        for (IArg arg : args) {
            treeArgs.add(SemRole.recalculate(roleset, (IArg<? extends INode>)arg, tree));
        }
        Collections.sort(treeArgs, ArgComparator.getInstance());
        return new SemRole((IRoleset)roleset, parse, terminal, fs.getForm(), fs.getTense(), fs.getAspect(), fs.isThirdPerson(), fs.isActive(), (List<? extends ISemArg>)treeArgs, false);
    }

    protected IRole getRole(String label, IRoleset roleset) {
        if (roleset == null) {
            return null;
        }
        for (IRole role : roleset.getRoles()) {
            if (!role.getLabel().toString().equalsIgnoreCase(label)) continue;
            return role;
        }
        return null;
    }

    public IModelChange getBatchModelChange() {
        return new GenerateSemroleModelChange();
    }
}

