/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timelink;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.timelink.IRelType;
import edu.mit.semantics.core.rep.timelink.LinkTypeAspectual;
import edu.mit.semantics.core.rep.timelink.LinkTypeSubordinate;
import edu.mit.semantics.core.rep.timelink.LinkTypeTemporal;
import edu.mit.semantics.core.rep.timex3.Timex3Rep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LinkType implements IHasName
{
    TEMPORAL("Temporal", LinkTypeTemporal.UNSPECIFIED, EventRep.getInstance(), Timex3Rep.getInstance()),
    SUBORDINATING("Subordinating", LinkTypeSubordinate.UNSPECIFIED, EventRep.getInstance()),
    ASPECTUAL("Aspectual", LinkTypeAspectual.UNSPECIFIED, EventRep.getInstance());

    private final Enum<? extends IRelType> unspecified;
    private final String name;
    private final IRep[] reps;

    private LinkType(String name, Enum<? extends IRelType> unspecified, IRep ... repArray) {
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (unspecified == null) {
            throw new NullPointerException();
        }
        if (repArray.length == 0) {
            throw new IllegalArgumentException();
        }
        if (Arrays.asList(repArray).contains(null)) {
            throw new NullPointerException();
        }
        this.name = name;
        this.unspecified = unspecified;
        this.reps = repArray;
    }

    public String getName() {
        return this.name;
    }

    public Enum<? extends IRelType> getUnspecifiedRelation() {
        return this.unspecified;
    }

    public boolean isAppropriateArgument(IDesc desc) {
        IRep[] iRepArray = this.reps;
        int n = this.reps.length;
        int n2 = 0;
        while (n2 < n) {
            IRep rep = iRepArray[n2];
            if (rep.isType((IHasRep)desc)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IRep[] getAppropriateReps() {
        return (IRep[])this.reps.clone();
    }
}

