/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.agreement.rand;

import edu.mit.story.core.agreement.rand.IContingencyTable;
import edu.mit.story.core.agreement.rand.RandIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdjustedRandIndex
extends RandIndex {
    private static AdjustedRandIndex instance;

    public static AdjustedRandIndex getInstance() {
        if (instance == null) {
            instance = new AdjustedRandIndex();
        }
        return instance;
    }

    protected AdjustedRandIndex() {
    }

    @Override
    public <T> double compute(IContingencyTable table) {
        double nCh2 = AdjustedRandIndex.choose(table.getSum(), 2);
        double sumEntriesCh2 = 0.0;
        int r = 0;
        while (r < table.numRows()) {
            int c = 0;
            while (c < table.numColumns()) {
                sumEntriesCh2 += (double)AdjustedRandIndex.choose(table.get(r, c), 2);
                ++c;
            }
            ++r;
        }
        double sumRowSumsCh2 = 0.0;
        int r2 = 0;
        while (r2 < table.numRows()) {
            sumRowSumsCh2 += (double)AdjustedRandIndex.choose(table.getRowSum(r2), 2);
            ++r2;
        }
        double sumColSumsCh2 = 0.0;
        int c = 0;
        while (c < table.numColumns()) {
            sumColSumsCh2 += (double)AdjustedRandIndex.choose(table.getColumnSum(c), 2);
            ++c;
        }
        double normalizedSumsCh2 = sumRowSumsCh2 * sumColSumsCh2 / nCh2;
        double numer = sumEntriesCh2 - normalizedSumsCh2;
        double denom = (sumRowSumsCh2 + sumColSumsCh2) / 2.0 - normalizedSumsCh2;
        return numer / denom;
    }

    public static /* bridge */ /* synthetic */ RandIndex getInstance() {
        return AdjustedRandIndex.getInstance();
    }
}

