/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.manager;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.descriptor.IConfigurableDescriptor;
import edu.mit.story.core.manager.ConfigurableManager;
import edu.mit.story.core.manager.IAssistantManager;
import edu.mit.story.core.manager.IRegisteredConfigurable;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AssistantManager<R extends IRegisteredConfigurable, D extends IConfigurableDescriptor<R>>
extends ConfigurableManager<R, D>
implements IAssistantManager<R, D> {
    private Map<IRep, D> defaultMap = new TreeMap<IRep, D>();
    private Map<IRep, List<D>> assistantMap = new TreeMap<IRep, List<D>>();

    @Override
    public void init() {
        super.init();
        this.makeUnmodifiable();
    }

    protected void makeUnmodifiable() {
        this.defaultMap = Collections.unmodifiableMap(this.defaultMap);
        for (Map.Entry<IRep, List<D>> entry : this.assistantMap.entrySet()) {
            entry.setValue(Collections.unmodifiableList(entry.getValue()));
        }
        this.assistantMap = Collections.unmodifiableMap(this.assistantMap);
    }

    @Override
    public boolean supports(IRep rep) {
        return this.assistantMap.containsKey(rep);
    }

    @Override
    public boolean supportsAll(Collection<? extends IRep> reps) {
        return this.assistantMap.keySet().containsAll(reps);
    }

    @Override
    public Iterator<IRep> repIterator() {
        return this.assistantMap.keySet().iterator();
    }

    @Override
    public int repSize() {
        return this.assistantMap.size();
    }

    @Override
    public IRepSet getSupported() {
        return new RepSet(this.assistantMap.keySet());
    }

    protected void registerDefault(IRep rep, D desc) {
        if (desc == null) {
            return;
        }
        this.defaultMap.put(rep, desc);
        this.registerDescriptor(rep, desc);
    }

    protected void registerDescriptor(IRep rep, D desc) {
        if (desc == null) {
            return;
        }
        this.registerDescriptor(desc);
        List<D> list = this.assistantMap.get(rep);
        if (list == null) {
            list = new ArrayList<D>();
            this.assistantMap.put(rep, list);
        } else if (list.contains(desc)) {
            return;
        }
        list.add(desc);
    }

    @Override
    public D getPlatformDefault(IRep rep) {
        List<D> ds = this.getDescriptors(rep);
        return (D)(ds == null || ds.isEmpty() ? null : (IConfigurableDescriptor)ds.get(0));
    }

    @Override
    public D getDefault(IRep rep) {
        return (D)((IConfigurableDescriptor)this.defaultMap.get(rep));
    }

    @Override
    public List<D> getDescriptors(IRep rep) {
        return this.assistantMap.get(rep);
    }

    public static SortedMap<IRep, IConfigurationElement> getRepElements() {
        TreeMap<IRep, IConfigurationElement> result = new TreeMap<IRep, IConfigurationElement>();
        for (IConfigurationElement element : AssistantManager.getElements("edu.mit.story.core.representations", "representation")) {
            String repID = element.getAttribute("id");
            IRep rep = StoryPlugin.getDefault().getRepManager().getRep(repID);
            if (rep == null) break;
            result.put(rep, element);
        }
        return result;
    }
}

