/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model;

import edu.mit.story.core.desc.ForwardingDescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.ForwardingStoryData;
import edu.mit.story.core.model.ForwardingStoryModel;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.rep.IRep;

public class SubstituteStoryModel
extends ForwardingStoryModel {
    private final IDesc substitute;
    private final IDesc target;
    private final IStoryData subData;

    public SubstituteStoryModel(IDesc substitute, IDesc target, IMutableStoryModel model) {
        super(model);
        if (substitute == null) {
            throw new NullPointerException();
        }
        if (target == null) {
            throw new NullPointerException();
        }
        if (substitute.getRep() != target.getRep()) {
            throw new IllegalArgumentException();
        }
        this.substitute = substitute;
        this.target = target;
        this.subData = new SubstituteStoryData(model.getData());
    }

    public IStoryData getData() {
        return this.subData;
    }

    public class SubstituteDescSet
    extends ForwardingDescSet {
        public SubstituteDescSet(IDescSet backingSet) {
            super(backingSet);
        }

        public IDesc getDescription(long id) {
            if (id == SubstituteStoryModel.this.target.getID()) {
                return SubstituteStoryModel.this.substitute;
            }
            return super.getDescription(id);
        }
    }

    public class SubstituteStoryData
    extends ForwardingStoryData {
        private final IDescSet subDescSet;

        public SubstituteStoryData(IStoryData backingData) {
            super(backingData);
            this.subDescSet = new SubstituteDescSet(backingData.getDescriptions(SubstituteStoryModel.this.target.getRep()));
        }

        public IDesc getDescription(long id) {
            if (id == SubstituteStoryModel.this.target.getID()) {
                return SubstituteStoryModel.this.substitute;
            }
            return super.getDescription(id);
        }

        public IDescSet getDescriptions(IRep rep) {
            if (rep == SubstituteStoryModel.this.target.getRep()) {
                return this.subDescSet;
            }
            return super.getDescriptions(rep);
        }
    }
}

