/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.notify;

import edu.mit.story.core.notify.ChangeNotifier;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.validation.Message;
import org.eclipse.jface.dialogs.IMessageProvider;

public abstract class NotifyingMessageProvider
extends ChangeNotifier
implements INotifyingMessageProvider {
    private IMessageProvider message = Message.NO_MESSAGE;
    private boolean outOfSync = true;

    public String getMessage() {
        if (this.outOfSync) {
            IMessageProvider newMessage = this.calculateMessage();
            if (newMessage == null) {
                newMessage = Message.NO_MESSAGE;
            }
            this.message = newMessage;
            this.outOfSync = false;
        }
        return this.message.getMessage();
    }

    public int getMessageType() {
        if (this.outOfSync) {
            this.message = this.calculateMessage();
            this.outOfSync = false;
        }
        return this.message.getMessageType();
    }

    protected abstract String getDebugName();

    protected boolean isOutOfSync() {
        return this.outOfSync;
    }

    protected void setOutOfSync() {
        this.outOfSync = true;
    }

    protected final void fireChanged() {
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    protected abstract IMessageProvider calculateMessage();
}

