/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.rep.text;

import edu.mit.story.core.rep.text.IndexedTextType;
import edu.mit.story.core.rep.text.TextRegion;
import java.util.Arrays;
import org.eclipse.jface.text.ITextStore;

public class ParagraphBoundDetector {
    static final char NEWLINE = '\n';

    public static boolean isWhitespace(char c, char[] cs) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        if (cs != null) {
            return Arrays.binarySearch(cs, c) >= 0;
        }
        return false;
    }

    public static State nextState(State state, char next, char[] ignore) {
        if (state == State.TEXT) {
            if (next == '\n') {
                return State.SAW_NEWLINE;
            }
            return State.TEXT;
        }
        if (state == State.SAW_NEWLINE) {
            if (next == '\n') {
                return State.POSSIBLE_BOUND;
            }
            if (ParagraphBoundDetector.isWhitespace(next, ignore)) {
                return State.SAW_NEWLINE;
            }
            return State.TEXT;
        }
        if (state == State.POSSIBLE_BOUND | state == State.EXPECTING_BOUND) {
            if (next == '\n') {
                return State.POSSIBLE_BOUND;
            }
            if (ParagraphBoundDetector.isWhitespace(next, ignore)) {
                return State.EXPECTING_BOUND;
            }
            return State.NEXT_TEXT_START;
        }
        if (state == State.NEXT_TEXT_START) {
            return State.TEXT;
        }
        return state;
    }

    public static int findLeftBound(int index, ITextStore store, IndexedTextType region) {
        index = Math.max(index, region.getOffset());
        index = Math.min(index, region.getRightOffset());
        int bound = region.getOffset();
        int lastBound = -1;
        while (bound < index & bound != lastBound) {
            lastBound = bound;
            bound = ParagraphBoundDetector.findNext(bound, store, region);
        }
        if (lastBound == -1) {
            return region.getOffset();
        }
        return lastBound;
    }

    public static int findRightBound(int index, ITextStore store, IndexedTextType region) {
        index = Math.max(index, region.getOffset());
        index = Math.min(index, region.getRightOffset());
        int bound = region.getOffset();
        int lastBound = -1;
        while (bound <= index & bound != lastBound) {
            lastBound = bound;
            bound = ParagraphBoundDetector.findNext(bound, store, region);
        }
        return bound;
    }

    public static int findNext(int start, ITextStore store, IndexedTextType region) {
        int end = region.getRightOffset();
        State state = State.TEXT;
        int firstChar = region.getOffset();
        while (firstChar < region.getRightOffset()) {
            if (!ParagraphBoundDetector.isWhitespace(store.get(firstChar), ((TextRegion)region.getData()).getIgnoredChars())) break;
            ++firstChar;
        }
        int i = start = Math.max(firstChar, start);
        while (i < region.getRightOffset() & i < store.getLength()) {
            if ((state = ParagraphBoundDetector.nextState(state, store.get(i), ((TextRegion)region.getData()).getIgnoredChars())) == State.POSSIBLE_BOUND) {
                end = i + 1;
            }
            if (state == State.NEXT_TEXT_START) {
                return end;
            }
            ++i;
        }
        return region.getRightOffset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        TEXT("text"),
        SAW_NEWLINE("saw_newline"),
        POSSIBLE_BOUND("possible_bound"),
        EXPECTING_BOUND("expecting_bound"),
        NEXT_TEXT_START("text_start");

        final String fName;

        private State(String name) {
            this.fName = name;
        }

        public String toString() {
            return this.fName;
        }
    }
}

