/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.validation;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.validation.FilePathValidator;
import edu.mit.story.core.validation.Message;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class ExistingFileValidator
extends FilePathValidator {
    private boolean workspacePath;

    public ExistingFileValidator() {
        this(false);
    }

    public ExistingFileValidator(boolean workspacePath) {
        this.workspacePath = workspacePath;
    }

    public Message validate(String pathString) {
        Message msg = super.validate(pathString);
        if (msg != null) {
            return msg;
        }
        if (this.workspacePath) {
            Path path = new Path(pathString);
            IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (file.getType() == 1 && file.exists()) {
                return null;
            }
            String message = NLS.bind((String)StoryMessages.MSG_FileDoesNotExist, (Object)file.getName());
            return new Message(message, 3);
        }
        File file = new File(pathString);
        if (file.getName().equals("")) {
            return emptyPath;
        }
        if (!file.exists() | file.isDirectory()) {
            String message = NLS.bind((String)StoryMessages.MSG_FileDoesNotExist, (Object)file.getName());
            return new Message(message, 3);
        }
        return null;
    }

    public boolean allowsInitialInvalidValue() {
        return true;
    }
}

