/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.views;

import edu.mit.discourse.core.rep.relation.IRelation;
import edu.mit.discourse.core.rep.relation.Relation;
import edu.mit.discourse.core.rep.relation.RelationRep;
import edu.mit.discourse.ui.DiscourseUIMessages;
import edu.mit.discourse.ui.actions.EditRelationAction;
import edu.mit.discourse.ui.content.RelationListContentProvider;
import edu.mit.discourse.ui.label.RelationListLabelProvider;
import edu.mit.discourse.ui.widgets.RelationViewer;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.property.IPropertyModifyListener;
import edu.mit.story.core.property.PropertyModifyEvent;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.Debug;
import edu.mit.story.core.util.IHasRefresh;
import edu.mit.story.ui.actions.ActionUtils;
import edu.mit.story.ui.actions.DescActionUtils;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.generic.DeleteDescAction;
import edu.mit.story.ui.actions.generic.RefreshAction;
import edu.mit.story.ui.actions.groups.StoryEditorUndoRedoActionGroup;
import edu.mit.story.ui.editor.IStoryEditor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class RelationListView
extends PageBookView
implements IHasRefresh {
    IAction refreshAction;

    public void createPartControl(Composite parent) {
        this.createActions();
        super.createPartControl(parent);
    }

    protected void createActions() {
        this.refreshAction = new RefreshAction((IHasRefresh)this);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = actionBars.getToolBarManager();
        toolbar.add(this.refreshAction);
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.refreshAction);
        actionBars.updateActionBars();
    }

    public void refresh() {
        IPage page = this.getCurrentPage();
        if (page instanceof IHasRefresh) {
            ((IHasRefresh)page).refresh();
        }
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(DiscourseUIMessages.MSG_NoRelationListAvailable);
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        Object page;
        IStoryEditor editor = (IStoryEditor)part;
        if (editor.getStoryModel().supports(RelationRep.getInstance())) {
            page = new RelationListViewPage(editor, this);
        } else {
            page = new MessagePage();
            page.setMessage(DiscourseUIMessages.MSG_NoRelationListAvailable);
        }
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec(part, (IPage)page);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        pageRecord.page.dispose();
        pageRecord.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IStoryEditor;
    }

    public static class RelationListViewPage
    extends Page
    implements IHasRefresh,
    IAdaptable,
    IModelListener,
    ISelectionListener,
    ISelectionProvider,
    ISelectionChangedListener,
    IPropertyModifyListener {
        IStoryEditor editor;
        RelationListView view;
        SashForm pageParent;
        TreeViewer treeViewer;
        RelationViewer relationViewer;
        ActionGroup undoRedoGroup;
        IAction deleteAction;
        IAction editAction;
        ListenerList selectionChangedListeners = new ListenerList();

        public RelationListViewPage(IStoryEditor editor, RelationListView view) {
            this.view = view;
            this.editor = editor;
        }

        public Control getControl() {
            return this.pageParent;
        }

        public void createControl(Composite parent) {
            this.pageParent = new SashForm(parent, 512);
            this.createTreeViewer((Composite)this.pageParent);
            this.createDetailPane((Composite)this.pageParent);
            this.pageParent.setWeights(new int[]{1, 2});
            this.editor.getStoryModel().addModelListener((IModelListener)this);
            this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
            this.getSite().setSelectionProvider((ISelectionProvider)this);
            this.createActions();
        }

        protected void createTreeViewer(Composite parent) {
            this.treeViewer = new TreeViewer(parent, 772);
            this.treeViewer.setAutoExpandLevel(-1);
            this.treeViewer.setContentProvider((IContentProvider)new RelationListContentProvider(this.editor));
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new RelationListLabelProvider(this.editor));
            this.treeViewer.setInput((Object)this.editor);
            this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        protected void createDetailPane(Composite parent) {
            Composite detailGroup = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            detailGroup.setLayout((Layout)layout);
            Label label = new Label(detailGroup, 0);
            label.setText("Relation Details");
            label.setLayoutData((Object)new GridData(4, 4, true, false));
            this.relationViewer = new RelationViewer(detailGroup, 0, 128);
            this.relationViewer.setLayoutData(new GridData(4, 4, true, true));
        }

        protected Label createLabel(Composite parent, String name) {
            Label label = new Label(parent, 0);
            label.setText(name);
            JFaceColors.setColors((Control)label, (Color)parent.getForeground(), (Color)parent.getBackground());
            return label;
        }

        protected void createActions() {
            this.undoRedoGroup = new StoryEditorUndoRedoActionGroup(this.editor);
            this.deleteAction = new DeleteDescAction(this.editor, (ISelectionProvider)this.getTreeViewer());
            this.editAction = new EditRelationAction(this.editor, (ISelectionProvider)this.getTreeViewer());
            MenuManager manager = new MenuManager();
            ActionUtils.createPopupGroups((IMenuManager)manager);
            this.undoRedoGroup.fillContextMenu((IMenuManager)manager);
            manager.appendToGroup("group.edit", this.editAction);
            manager.appendToGroup("group.edit", this.deleteAction);
            ActionUtils.createPopupGroups((IMenuManager)manager);
            Menu menu = manager.createContextMenu(this.getControl());
            this.getTreeViewer().getTree().setMenu(menu);
            String menuID = "edu.mit.discourse.popup.relationsView";
            this.view.getSite().registerContextMenu(menuID, manager, (ISelectionProvider)this.getTreeViewer());
            IActionBars actionBars = this.getSite().getActionBars();
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.deleteAction);
            this.undoRedoGroup.fillActionBars(actionBars);
            actionBars.updateActionBars();
        }

        public void propertiesModified(PropertyModifyEvent e) {
            Debug.out();
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part == this.view) {
                return;
            }
            IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)selection, IDesc.class);
            if (desc == null) {
                return;
            }
            if (RelationRep.getInstance().isType((IHasRep)desc)) {
                this.treeViewer.setSelection(selection);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IDesc d = (IDesc)SelectionUtils.extractSingle((ISelection)this.getSelection(), IDesc.class);
            this.editAction.setEnabled(d != null);
            this.deleteAction.setEnabled(d != null);
            this.fireSelectionChanged();
        }

        public void modelChanged(StoryChangeEvent e) {
            if (e == null || !e.changes.containsKey(RelationRep.getInstance())) {
                return;
            }
            this.refresh();
        }

        public TreeViewer getTreeViewer() {
            return this.treeViewer;
        }

        public void setFocus() {
            this.getTreeViewer().getTree().setFocus();
        }

        public void dispose() {
            this.editor.getStoryModel().removeModelListener((IModelListener)this);
            this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
            super.dispose();
        }

        public void refresh() {
            this.treeViewer.refresh();
            this.relationViewer.refresh();
        }

        public ISelection getSelection() {
            IDesc desc = DescActionUtils.extractSingle((ISelection)this.getTreeViewer().getSelection(), (IRep)RelationRep.getInstance());
            this.relationViewer.setInput((IRelation)(desc == null ? null : (Relation)desc.getData()));
            IStoryModel p = (IStoryModel)SelectionUtils.extractSingle((ISelection)this.treeViewer.getSelection(), IStoryModel.class);
            return p == null ? this.treeViewer.getSelection() : null;
        }

        public void setSelection(ISelection selection) {
            this.getTreeViewer().setSelection(selection);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.add((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.remove((Object)listener);
        }

        protected void fireSelectionChanged() {
            ISelection selection = this.getSelection();
            if (selection == null) {
                return;
            }
            final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            Object[] objectArray = this.selectionChangedListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                final ISelectionChangedListener l = (ISelectionChangedListener)listener;
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.selectionChanged(event);
                    }
                });
                ++n2;
            }
        }

        public Object getAdapter(Class adapter) {
            return this.editor.getAdapter(adapter);
        }
    }
}

