/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.AbstractTreeExtractor;
import edu.stanford.nlp.parser.lexparser.IntDependency;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammar;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Numberer;
import java.util.List;

class MLEDependencyGrammarExtractor
extends AbstractTreeExtractor {
    protected Numberer wordNumberer = Numberer.getGlobalNumberer("words");
    protected Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
    protected Counter<IntDependency> dependencyCounter = new Counter();
    protected TreebankLangParserParams tlpParams;
    protected boolean directional;
    protected boolean useDistance;
    protected boolean useCoarseDistance;

    public MLEDependencyGrammarExtractor(Options op) {
        this.tlpParams = op.tlpParams;
        this.directional = op.directional;
        this.useDistance = op.distance;
        this.useCoarseDistance = op.coarseDistance;
    }

    protected void tallyRoot(Tree lt) {
        List<IntDependency> deps = MLEDependencyGrammar.treeToDependencyList(lt);
        for (IntDependency dependency : deps) {
            this.dependencyCounter.incrementCount(dependency);
        }
    }

    protected Object formResult() {
        this.wordNumberer.number("UNK");
        MLEDependencyGrammar dg = new MLEDependencyGrammar(this.tlpParams, this.directional, this.useDistance, this.useCoarseDistance);
        for (IntDependency dependency : this.dependencyCounter.keySet()) {
            dg.addRule(dependency, this.dependencyCounter.getCount(dependency));
        }
        return dg;
    }
}

