/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ASBCDict {
    private static final String defaultFilename = "/juice/scr1/htseng/maxent/maxent-20040930/pos-task4/data/genfeature/adbcdict";
    private static ASBCDict ASBCDictSingleton = null;
    public static HashMap<String, Set<String>> ASBC_pre_dict;
    public static HashMap<String, Set<String>> ASBC_suf_dict;

    public static ASBCDict getInstance() {
        if (ASBCDictSingleton == null) {
            ASBCDictSingleton = new ASBCDict(0);
        }
        return ASBCDictSingleton;
    }

    private ASBCDict(int i) {
        ASBCDict.readASBCDict(defaultFilename);
    }

    private static void readASBCDict(String filename) {
        try {
            String ASBCDetectorLine;
            BufferedReader ASBCDetectorReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "GB18030"));
            ASBC_pre_dict = new HashMap();
            ASBC_suf_dict = new HashMap();
            while ((ASBCDetectorLine = ASBCDetectorReader.readLine()) != null) {
                String[] fields = ASBCDetectorLine.split("\t");
                String tag = fields[0];
                Set<String> pres = ASBC_pre_dict.get(tag);
                Set<String> sufs = ASBC_suf_dict.get(tag);
                if (pres == null) {
                    pres = new HashSet<String>();
                    ASBC_pre_dict.put(tag, pres);
                }
                pres.add(fields[1]);
                if (sufs == null) {
                    sufs = new HashSet<String>();
                    ASBC_suf_dict.put(tag, sufs);
                }
                sufs.add(fields[2]);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("ASBC not found");
            System.exit(-1);
        }
        catch (IOException e) {
            System.err.println("ASBC");
            System.exit(-1);
        }
    }

    public static String getTagPre(String a1, String a2) {
        ASBCDict dict = ASBCDict.getInstance();
        if (dict.getpre(a1) == null) {
            return "0";
        }
        if (dict.getpre(a1).contains(a2)) {
            return "1";
        }
        return "0";
    }

    public static String getTagSuf(String a1, String a2) {
        ASBCDict dict = ASBCDict.getInstance();
        if (dict.getsuf(a1) == null) {
            return "0";
        }
        if (dict.getsuf(a1).contains(a2)) {
            return "1";
        }
        return "0";
    }

    Set getpre(String a) {
        return ASBC_pre_dict.get(a);
    }

    Set getsuf(String a) {
        return ASBC_suf_dict.get(a);
    }
}

