/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class ButtonAction
extends Action
implements IPropertyChangeListener,
DisposeListener {
    public static final String ACTIONDEFINITIONID = "actionDefinitionId";
    private final Button button;

    public ButtonAction(Button button) {
        this.button = button;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ButtonAction.this.run();
            }
        });
        this.addPropertyChangeListener(this);
        button.addDisposeListener((DisposeListener)this);
    }

    protected void refreshToolTip() {
        if (this.button == null || this.button.isDisposed()) {
            return;
        }
        String tooltip = this.getToolTipText();
        if (tooltip == null) {
            this.button.setToolTipText(null);
            return;
        }
        IBindingService bindings = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        String commandID = this.getActionDefinitionId();
        TriggerSequence sequence = commandID == null ? null : bindings.getBestActiveBindingFor(commandID);
        String binding = sequence == null ? null : " (" + sequence.format() + ")";
        tooltip = binding == null ? tooltip : String.valueOf(tooltip) + binding;
        this.button.setToolTipText(tooltip);
    }

    public Button getButton() {
        return this.button;
    }

    public void setActionDefinitionId(String newID) {
        String oldID = this.getActionDefinitionId();
        super.setActionDefinitionId(newID);
        ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
        if (oldID != null) {
            callback.removePropertyChangeListener(oldID, (IPropertyChangeListener)this);
        }
        if (newID != null) {
            callback.addPropertyChangeListener(newID, (IPropertyChangeListener)this);
        }
        this.firePropertyChange(ACTIONDEFINITIONID, oldID, newID);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if ("enabled".equals(prop)) {
            this.button.setEnabled(this.isEnabled());
            return;
        }
        if ("text".equals(prop) || "toolTipText".equals(prop) || ACTIONDEFINITIONID.equals(prop)) {
            this.refreshToolTip();
            return;
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        String id = this.getActionDefinitionId();
        if (id == null) {
            return;
        }
        ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
        callback.removePropertyChangeListener(id, (IPropertyChangeListener)this);
    }
}

