/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards.page;

import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.core.validation.ExistingFileValidator;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.LogicalAndValidator;
import edu.mit.story.core.validation.Message;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.content.StoryProjectFilter;
import edu.mit.story.ui.validation.ContainerValidator;
import edu.mit.story.ui.validation.FullPathValidationLogic;
import edu.mit.story.ui.validation.StoryProjectValidator;
import edu.mit.story.ui.widgets.FilteredContainerSelectionGroup;
import edu.mit.story.ui.widgets.InputStoryFilenameGroup;
import edu.mit.story.ui.widgets.PathSpecificationGroup;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ImportStoryPage
extends WizardPage
implements ChangeListener {
    public static final String NAME = StringUtils.getClassName(ImportStoryPage.class);
    protected PathSpecificationGroup pathGroup;
    public static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
    protected Composite topGroup;
    public InputStoryFilenameGroup filenameGroup;
    protected FilteredContainerSelectionGroup containerGroup;
    protected MessageProviderManager manager;
    protected String initialFile = "";
    protected IPath initialPath = null;
    protected Map<String, String> initialTags = new HashMap<String, String>();

    public ImportStoryPage() {
        super(NAME);
        this.setTitle(StoryUIMessages.WIZARD_PAGE_ImportStory_title);
        this.setDescription(StoryUIMessages.WIZARD_PAGE_ImportStory_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Message message = new Message(this.getDescription(), 0);
        this.manager = new MessageProviderManager((IMessageProvider)message, (ChangeListener)this);
        this.topGroup = new Composite(parent, 0);
        this.topGroup.setLayout((Layout)new GridLayout());
        this.topGroup.setLayoutData((Object)new GridData(272));
        this.topGroup.setFont(parent.getFont());
        this.setControl((Control)this.topGroup);
        this.filenameGroup = new InputStoryFilenameGroup(this.topGroup, this.initialFile);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.filenameGroup.setLayoutData(data);
        this.manager.add((INotifyingMessageProvider)this.filenameGroup);
        this.pathGroup = new PathSpecificationGroup(this.topGroup, StoryUIMessages.WIZARD_PAGE_ImportSourceFileEntry_label, (IValidator<String>)new ExistingFileValidator());
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.pathGroup.setLayoutData(data);
        this.manager.add((INotifyingMessageProvider)this.pathGroup);
        LogicalAndValidator validator = new LogicalAndValidator();
        validator.add((Object)new ContainerValidator());
        validator.add((Object)new StoryProjectValidator());
        this.containerGroup = new FilteredContainerSelectionGroup(this.topGroup, true, true, null, new StoryProjectFilter(), StoryUIMessages.ContainerGroup_Message_EnableStoryProjectFilter, (IValidator<IPath>)validator, 250);
        if (this.initialPath != null) {
            this.containerGroup.setContainerFullPath(this.initialPath);
        }
        this.manager.add((INotifyingMessageProvider)this.containerGroup);
        this.manager.add((INotifyingMessageProvider)new FullPathValidationLogic(this.filenameGroup, this.containerGroup));
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    public void setSelection(ISelection selection) {
        IAdaptable adaptable;
        IResource selRes = SelectionUtils.extractFirst(selection, IResource.class);
        if (selRes == null && (adaptable = SelectionUtils.extractFirst(selection, IAdaptable.class)) != null) {
            selRes = (IResource)adaptable.getAdapter(IResource.class);
        }
        if (selRes != null) {
            if (selRes.getType() == 1) {
                selRes = selRes.getParent();
            }
            if (selRes.isAccessible()) {
                this.setContainerPath(selRes.getFullPath());
            }
        }
    }

    public void setFilename(String value) {
        if (this.filenameGroup == null) {
            this.initialFile = value;
        } else {
            this.filenameGroup.setValue(value);
        }
    }

    public void setContainerPath(IPath path) {
        if (this.containerGroup == null) {
            this.initialPath = path;
        } else {
            this.containerGroup.setContainerFullPath(path);
        }
    }

    public String getFilename() {
        return this.filenameGroup == null ? this.initialFile : this.filenameGroup.getValue();
    }

    public IPath getSourcePath() {
        return this.pathGroup.getFilePath();
    }

    public IProject getProject() {
        return this.containerGroup == null ? null : this.containerGroup.getSelectedProject();
    }

    public IPath getContainerPath() {
        return this.containerGroup.getContainerFullPath();
    }

    public IPath getFullPath() {
        IPath result = this.getContainerPath();
        return result == null ? null : result.append(this.getFilename());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.filenameGroup.setFocus();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.setPageComplete(this.manager.getMessageType() != 3);
        this.setMessage(this.manager.getMessage(), this.manager.getMessageType());
    }
}

