/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.actions;

import edu.mit.jpropbank.Aspect;
import edu.mit.jpropbank.Form;
import edu.mit.jpropbank.IPredicateFeatures;
import edu.mit.jpropbank.Tense;
import edu.mit.semantics.core.rep.semrole.ISemRole;
import edu.mit.semantics.core.rep.semrole.SemRole;
import edu.mit.semantics.core.rep.semrole.SemRoleRep;
import edu.mit.semantics.ui.content.SemRoleContentProvider;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.ActionGroup;

public class ChangeSemRoleFeatureActionGroup
extends ActionGroup {
    private IMenuManager activeMenu;
    private IMenuManager thirdMenu;
    private IMenuManager tenseMenu;
    private IMenuManager aspectMenu;
    private IMenuManager formMenu;

    public ChangeSemRoleFeatureActionGroup(IStoryEditor editor, ISelectionProvider provider) {
        this.createActions(editor, provider);
    }

    public IRep getRep() {
        return SemRoleRep.getInstance();
    }

    protected void createActions(IStoryEditor editor, ISelectionProvider provider) {
        this.activeMenu = new MenuManager("&Active");
        this.activeMenu.setRemoveAllWhenShown(true);
        this.activeMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new ChangeActiveAction(Boolean.TRUE, editor, provider));
                manager.add((IAction)new ChangeActiveAction(Boolean.FALSE, editor, provider));
            }
        });
        this.thirdMenu = new MenuManager("Third &Person");
        this.thirdMenu.setRemoveAllWhenShown(true);
        this.thirdMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new ChangeThirdAction(Boolean.TRUE, editor, provider));
                manager.add((IAction)new ChangeThirdAction(Boolean.FALSE, editor, provider));
            }
        });
        this.tenseMenu = new MenuManager("&Tense");
        this.tenseMenu.setRemoveAllWhenShown(true);
        this.tenseMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Tense[] tenseArray = Tense.values();
                int n = tenseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Tense f = tenseArray[n2];
                    manager.add((IAction)new ChangeTenseAction(f, editor, provider));
                    ++n2;
                }
            }
        });
        this.aspectMenu = new MenuManager("&Aspect");
        this.aspectMenu.setRemoveAllWhenShown(true);
        this.aspectMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Aspect[] aspectArray = Aspect.values();
                int n = aspectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Aspect f = aspectArray[n2];
                    manager.add((IAction)new ChangeAspectAction(f, editor, provider));
                    ++n2;
                }
            }
        });
        this.formMenu = new MenuManager("&Form");
        this.formMenu.setRemoveAllWhenShown(true);
        this.formMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Form[] formArray = Form.values();
                int n = formArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Form f = formArray[n2];
                    manager.add((IAction)new ChangeFormAction(f, editor, provider));
                    ++n2;
                }
            }
        });
    }

    protected static String extractName(Object obj) {
        StringBuilder sb = new StringBuilder();
        if (obj instanceof IHasName) {
            sb.append(((IHasName)obj).getName());
        } else {
            sb.append(obj.toString());
        }
        sb.insert(0, '&');
        return sb.toString();
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean all;
        Object element = SelectionUtils.extractSingle((ISelection)this.getContext().getSelection(), Object.class);
        Object obj = element;
        if (obj instanceof StoryEditorContentProvider.Element) {
            StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)obj;
            obj = child.getElement();
        }
        if (obj instanceof IDesc) {
            IDesc d = (IDesc)obj;
            if (this.getRep().isType((IHasRep)d)) {
                obj = d.getData();
            }
        }
        if ((all = obj instanceof IPredicateFeatures) || SemRoleContentProvider.isElement((Object)element, (int)2)) {
            menu.appendToGroup("additions", (IContributionItem)this.activeMenu);
        }
        if (all || SemRoleContentProvider.isElement((Object)element, (int)3)) {
            menu.appendToGroup("additions", (IContributionItem)this.thirdMenu);
        }
        if (all || obj instanceof Tense) {
            menu.appendToGroup("additions", (IContributionItem)this.tenseMenu);
        }
        if (all || obj instanceof Aspect) {
            menu.appendToGroup("additions", (IContributionItem)this.aspectMenu);
        }
        if (all || obj instanceof Form) {
            menu.appendToGroup("additions", (IContributionItem)this.formMenu);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeActiveAction
    extends ChangeSemRoleFeatureAction<Boolean> {
        public ChangeActiveAction(Boolean feature, IStoryEditor editor, ISelectionProvider provider) {
            super(feature, editor, provider);
        }

        @Override
        protected boolean isChecked(ISemRole e) {
            return e.isActive() == ((Boolean)this.getFeature()).booleanValue();
        }

        @Override
        protected ISemRole create(ISemRole oldSemRole) {
            return new SemRole(oldSemRole.getRoleset(), oldSemRole.getParse(), oldSemRole.getTerminal(), oldSemRole.getForm(), oldSemRole.getTense(), oldSemRole.getAspect(), oldSemRole.isThirdPerson(), ((Boolean)this.getFeature()).booleanValue(), oldSemRole.getArguments(), true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeAspectAction
    extends ChangeSemRoleFeatureAction<Aspect> {
        public ChangeAspectAction(Aspect feature, IStoryEditor editor, ISelectionProvider provider) {
            super(feature, editor, provider);
        }

        @Override
        protected boolean isChecked(ISemRole e) {
            return e.getAspect() == this.getFeature();
        }

        @Override
        protected ISemRole create(ISemRole oldSemRole) {
            return new SemRole(oldSemRole.getRoleset(), oldSemRole.getParse(), oldSemRole.getTerminal(), oldSemRole.getForm(), oldSemRole.getTense(), (Aspect)this.getFeature(), oldSemRole.isActive(), oldSemRole.isThirdPerson(), oldSemRole.getArguments(), true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeFormAction
    extends ChangeSemRoleFeatureAction<Form> {
        public ChangeFormAction(Form feature, IStoryEditor editor, ISelectionProvider provider) {
            super(feature, editor, provider);
        }

        @Override
        protected boolean isChecked(ISemRole e) {
            return e.getForm() == this.getFeature();
        }

        @Override
        protected ISemRole create(ISemRole oldSemRole) {
            return new SemRole(oldSemRole.getRoleset(), oldSemRole.getParse(), oldSemRole.getTerminal(), (Form)this.getFeature(), oldSemRole.getTense(), oldSemRole.getAspect(), oldSemRole.isActive(), oldSemRole.isThirdPerson(), oldSemRole.getArguments(), true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ChangeSemRoleFeatureAction<F>
    extends Action {
        private F feature;
        private IStoryEditor editor;
        private ISelectionProvider provider;

        public ChangeSemRoleFeatureAction(F feature, IStoryEditor editor, ISelectionProvider provider) {
            super(ChangeSemRoleFeatureActionGroup.extractName(feature), 2);
            if (feature == null) {
                throw new NullPointerException();
            }
            if (editor == null) {
                throw new NullPointerException();
            }
            if (provider == null) {
                throw new NullPointerException();
            }
            this.feature = feature;
            this.editor = editor;
            this.provider = provider;
        }

        public F getFeature() {
            return this.feature;
        }

        protected IDesc getTargetDesc() {
            Object element = SelectionUtils.extractSingle((ISelection)this.provider.getSelection(), Object.class);
            if (element instanceof StoryEditorContentProvider.Element) {
                StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
                element = child.getParent();
            }
            if (element instanceof IDesc) {
                IDesc d = (IDesc)element;
                if (ChangeSemRoleFeatureActionGroup.this.getRep().isType((IHasRep)d)) {
                    return d;
                }
            }
            return null;
        }

        public boolean isChecked() {
            Object element = SelectionUtils.extractSingle((ISelection)this.provider.getSelection(), Object.class);
            if (element instanceof StoryEditorContentProvider.Element) {
                StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
                element = child.getParent();
            }
            if (element instanceof IDesc) {
                IDesc d = (IDesc)element;
                element = d.getData();
            }
            if (element instanceof ISemRole) {
                return this.isChecked((ISemRole)element);
            }
            return false;
        }

        protected abstract boolean isChecked(ISemRole var1);

        public void run() {
            IDesc oldDesc = this.getTargetDesc();
            if (oldDesc == null) {
                throw new IllegalStateException("no description on which to work");
            }
            ISemRole newSemRole = this.create((ISemRole)oldDesc.getData());
            Desc newDesc = new Desc(oldDesc.getID(), oldDesc.getRep(), newSemRole.calculatePosition(), (IData)newSemRole, (Iterable)oldDesc.getMetaData());
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)Origin.USER_SPECIFIED));
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)new Timing(((Object)((Object)this)).getClass().getCanonicalName(), true)));
            RemoveDescriptionsChange change = new RemoveDescriptionsChange(oldDesc);
            change = new CompositeModelChange(new IModelChange[]{change, new AddDescriptionsChange((IDesc)newDesc)});
            this.editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        }

        protected abstract ISemRole create(ISemRole var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeTenseAction
    extends ChangeSemRoleFeatureAction<Tense> {
        public ChangeTenseAction(Tense feature, IStoryEditor editor, ISelectionProvider provider) {
            super(feature, editor, provider);
        }

        @Override
        protected boolean isChecked(ISemRole e) {
            return e.getTense() == this.getFeature();
        }

        @Override
        protected ISemRole create(ISemRole oldSemRole) {
            return new SemRole(oldSemRole.getRoleset(), oldSemRole.getParse(), oldSemRole.getTerminal(), oldSemRole.getForm(), (Tense)this.getFeature(), oldSemRole.getAspect(), oldSemRole.isActive(), oldSemRole.isThirdPerson(), oldSemRole.getArguments(), true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeThirdAction
    extends ChangeSemRoleFeatureAction<Boolean> {
        public ChangeThirdAction(Boolean feature, IStoryEditor editor, ISelectionProvider provider) {
            super(feature, editor, provider);
        }

        @Override
        protected boolean isChecked(ISemRole e) {
            return e.isThirdPerson() == ((Boolean)this.getFeature()).booleanValue();
        }

        @Override
        protected ISemRole create(ISemRole oldSemRole) {
            return new SemRole(oldSemRole.getRoleset(), oldSemRole.getParse(), oldSemRole.getTerminal(), oldSemRole.getForm(), oldSemRole.getTense(), oldSemRole.getAspect(), ((Boolean)this.getFeature()).booleanValue(), oldSemRole.isActive(), oldSemRole.getArguments(), true);
        }
    }
}

