/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.semantics.core.rep.function.FunctionRep;
import edu.mit.semantics.core.rep.function.FunctionTag;
import edu.mit.semantics.core.rep.function.IFunction;
import edu.mit.semantics.core.rep.function.IFunctionInstance;
import edu.mit.semantics.core.rep.function.IFunctionTag;
import edu.mit.semantics.ui.SemanticsUIPlugin;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class FunctionLabelProvider
extends StoryModelLabelProvider {
    protected Image funcImg;
    protected Image instImg;
    protected Image segImg;

    public FunctionLabelProvider(IStoryEditor editor) {
        super(editor);
    }

    public StyledString getStyledText(Object element) {
        Object data = element;
        long id = -1L;
        if (data instanceof IDesc) {
            IDesc desc;
            IDesc iDesc = desc = data instanceof IDesc ? (IDesc)data : null;
            if (FunctionRep.getInstance().isType((IHasRep)desc)) {
                id = desc.getID();
                data = desc.getData();
            }
        }
        if (data instanceof IFunction) {
            IFunction function = (IFunction)data;
            IFunctionTag tag = function.getFunctionTag();
            StyledString result = new StyledString();
            result.append(FunctionTag.serialize((IFunctionTag)tag));
            FunctionLabelProvider.appendID((StyledString)result, (long)id);
            if (element instanceof IDesc) {
                FunctionLabelProvider.appendMergeTags((StyledString)result, (IDesc)((IDesc)element));
            }
            return result;
        }
        if (data instanceof IFunctionInstance) {
            IFunctionInstance inst = (IFunctionInstance)data;
            StyledString result = new StyledString();
            if (inst.getInstanceType() != IFunctionInstance.InstanceType.ACTUAL) {
                result.append(inst.getInstanceType().getName(), StyledString.COUNTER_STYLER);
                result.append(": ", StyledString.COUNTER_STYLER);
            }
            result.append(inst.getDisplayText());
            return result;
        }
        if (data instanceof ISegment) {
            ISegment segment = (ISegment)data;
            return new StyledString(segment.getDisplayText());
        }
        return super.getStyledText(data);
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc && FunctionRep.getInstance().isType((IHasRep)((IDesc)element))) {
            return this.getFunctionImage();
        }
        if (element instanceof IFunction) {
            return this.getFunctionImage();
        }
        if (element instanceof IFunctionInstance) {
            return this.getInstanceImage();
        }
        if (element instanceof ISegment) {
            return this.getSegmentImg();
        }
        return super.getImage(element);
    }

    protected Image getFunctionImage() {
        if (this.funcImg == null) {
            this.funcImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/timelink.gif");
        }
        return this.funcImg;
    }

    protected Image getInstanceImage() {
        if (this.instImg == null) {
            this.instImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/part.gif");
        }
        return this.instImg;
    }

    protected Image getSegmentImg() {
        if (this.segImg == null) {
            this.segImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/feature.gif");
        }
        return this.segImg;
    }
}

