/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.semantics.core.rep.timex3.ITimex3;
import edu.mit.semantics.core.rep.timex3.Timex3Rep;
import edu.mit.semantics.ui.SemanticsUIPlugin;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IHasStoryEditor;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class Timex3LabelProvider
extends StoryModelLabelProvider {
    private Image timexImg;
    private Image featImg;

    public Timex3LabelProvider(IStoryEditor editor) {
        super(editor);
    }

    public Timex3LabelProvider(IHasStoryEditor editorProvider) {
        super(editorProvider);
    }

    public StyledString getStyledText(Object element) {
        long id = -1L;
        IDesc desc = null;
        if (element instanceof IDesc) {
            desc = (IDesc)element;
            if (Timex3Rep.getInstance().isType((IHasRep)desc)) {
                id = desc.getID();
                element = desc.getData();
            }
        }
        if (element instanceof ITimex3) {
            ITimex3 timex = (ITimex3)element;
            StyledString result = new StyledString();
            result.append(timex.getExpression().getDisplayText());
            result.append(" (", StyledString.COUNTER_STYLER);
            result.append(timex.getType().getName(), StyledString.COUNTER_STYLER);
            result.append(')', StyledString.COUNTER_STYLER);
            result = Timex3LabelProvider.appendID((StyledString)result, (long)id);
            return desc == null ? result : Timex3LabelProvider.appendMergeTags((StyledString)result, (IDesc)desc);
        }
        if (element instanceof StoryEditorContentProvider.Element) {
            return this.getStyledText((StoryEditorContentProvider.Element)element);
        }
        return super.getStyledText(element);
    }

    protected StyledString getStyledText(StoryEditorContentProvider.Element child) {
        if (child.getElement() instanceof ITimex3.Mod) {
            ITimex3.Mod m = (ITimex3.Mod)child.getElement();
            StyledString result = new StyledString();
            result.append(m.getName());
            result.append(" (mod)", StyledString.COUNTER_STYLER);
            return result;
        }
        if (child.getElement() instanceof ITimex3.Function) {
            ITimex3.Function f = (ITimex3.Function)child.getElement();
            StyledString result = new StyledString();
            result.append(f.getName());
            result.append(" (func)", StyledString.COUNTER_STYLER);
            return result;
        }
        if (child.getType() == 1 && child.getElement() instanceof ISegmentSet) {
            ISegmentSet q = (ISegmentSet)child.getElement();
            StyledString result = new StyledString();
            result.append(q.getDisplayText());
            result.append(" (quant)", StyledString.COUNTER_STYLER);
            return result;
        }
        if (child.getType() == 2 && child.getElement() instanceof ISegmentSet) {
            ISegmentSet f = (ISegmentSet)child.getElement();
            StyledString result = new StyledString();
            result.append(f.getDisplayText());
            result.append(" (freq)", StyledString.COUNTER_STYLER);
            return result;
        }
        return super.getStyledText((Object)child);
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc) {
            return this.getTimexImg();
        }
        if (element instanceof ITimex3) {
            return this.getTimexImg();
        }
        if (element instanceof ITimex3.Mod) {
            return this.getFeatureImg();
        }
        if (element instanceof ITimex3.Function) {
            return this.getFeatureImg();
        }
        if (element instanceof StoryEditorContentProvider.Element) {
            return this.getFeatureImg();
        }
        return super.getImage(element);
    }

    protected Image getTimexImg() {
        if (this.timexImg == null) {
            this.timexImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/value.gif");
        }
        return this.timexImg;
    }

    protected Image getFeatureImg() {
        if (this.featImg == null) {
            this.featImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/feature.gif");
        }
        return this.featImg;
    }
}

