/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.controllers;

import edu.mit.parsing.core.model.ISegmentModel;
import edu.mit.parsing.ui.controllers.ISegmentController;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.ui.controllers.AnnotationController;
import edu.mit.story.ui.controllers.HasAnnotationController;
import edu.mit.story.ui.controllers.IAnnotationController;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentController
extends HasAnnotationController
implements IModelListener,
ISegmentController {
    private final IStoryEditor editor;
    private final ISegmentModel model;

    public SegmentController(ISegmentModel model, String annoID, IStoryEditor editor) {
        this(model, (IAnnotationController)new AnnotationController(annoID, editor), editor);
    }

    public SegmentController(ISegmentModel model, IAnnotationController annoController, IStoryEditor editor) {
        super(annoController);
        if (model == null) {
            throw new NullPointerException();
        }
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.model = model;
        editor.getStoryModel().addModelListener((IModelListener)this);
    }

    @Override
    public ISegmentModel getModel() {
        return this.model;
    }

    @Override
    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    @Override
    public void nextLeft() {
        IDescSet tokens = this.editor.getStoryModel().getData().getDescriptions(this.model.getRep());
        if (tokens.isEmpty()) {
            return;
        }
        IDescSet current = this.model.getSegment();
        if (current.isEmpty()) {
            this.setRange((IHasPosition)tokens.first(), null);
            return;
        }
        IDesc left = (IDesc)current.first();
        tokens = tokens.tailSet(left);
        Iterator i = tokens.iterator();
        i.next();
        if (i.hasNext()) {
            left = (IDesc)i.next();
            if ((current = current.tailSet(left)).isEmpty()) {
                this.setRange((IHasPosition)left);
            } else {
                this.setRange((IHasPosition)left, (IHasPosition)current.last());
            }
        }
    }

    @Override
    public void previousLeft() {
        IDescSet tokens = this.editor.getStoryModel().getData().getDescriptions(this.model.getRep());
        if (tokens.isEmpty()) {
            return;
        }
        IDescSet current = this.model.getSegment();
        if (current.isEmpty()) {
            this.setRange((IHasPosition)tokens.last());
            return;
        }
        IDesc left = (IDesc)current.first();
        if (!(tokens = tokens.headSet(left)).isEmpty()) {
            left = (IDesc)tokens.last();
            this.setRange((IHasPosition)left, (IHasPosition)current.last());
        }
    }

    @Override
    public void nextRight() {
        IDescSet tokens = this.editor.getStoryModel().getData().getDescriptions(this.model.getRep());
        if (tokens.isEmpty()) {
            return;
        }
        IDescSet current = this.model.getSegment();
        if (current.isEmpty()) {
            this.setRange((IHasPosition)tokens.first());
            return;
        }
        IDesc right = (IDesc)current.last();
        tokens = tokens.tailSet(right);
        Iterator i = tokens.iterator();
        i.next();
        if (i.hasNext()) {
            right = (IDesc)i.next();
            this.setRange((IHasPosition)current.first(), (IHasPosition)right);
        }
    }

    @Override
    public void previousRight() {
        IDescSet descs = this.editor.getStoryModel().getData().getDescriptions(this.model.getRep());
        if (descs.isEmpty()) {
            return;
        }
        IDescSet current = this.model.getSegment();
        if (current.isEmpty()) {
            this.setRange((IHasPosition)descs.last());
            return;
        }
        IDesc right = (IDesc)current.last();
        if (!(descs = descs.headSet(right)).isEmpty()) {
            right = (IDesc)descs.last();
            if ((current = current.tailSet(right)).isEmpty()) {
                this.setRange((IHasPosition)right);
            } else {
                this.setRange((IHasPosition)current.first(), (IHasPosition)right);
            }
        }
    }

    @Override
    public void capture() {
        IHasPosition selection = this.editor.getSelectedRange();
        if (selection == null) {
            return;
        }
        IDescSet descs = this.editor.getStoryModel().getData().getDescriptions(this.model.getRep());
        IDescSet iDescSet = descs = selection.getLength() == 0 ? descs.closedSet(selection) : descs.openSet(selection);
        if (!descs.isEmpty()) {
            this.setRange((IHasPosition)descs);
        }
    }

    @Override
    public void clear() {
        this.model.clear();
        this.getAnnotationController().clear();
    }

    public void dispose() {
        this.editor.getStoryModel().removeModelListener((IModelListener)this);
        this.model.dispose();
    }

    public void modelChanged(StoryChangeEvent e) {
        IDescSet segment = this.model.getSegment();
        if (segment.isEmpty()) {
            return;
        }
        IDescSet descs = this.editor.getStoryModel().getData().getDescriptions(this.model.getRep());
        DescSet newSegment = new DescSet(this.model.getRep());
        for (IDesc desc : segment) {
            if ((desc = descs.getDescription(desc.getID())) == null) {
                this.clear();
                return;
            }
            newSegment.add((Object)desc);
        }
        this.setRange((IHasPosition)newSegment);
    }

    protected void setRange(IHasPosition one, IHasPosition two) {
        this.setRange(PositionUtils.combine((IHasPosition)one, (IHasPosition)two));
    }

    protected void setRange(IHasPosition range) {
        if (range == null) {
            this.clear();
            return;
        }
        IDescSet descs = this.editor.getStoryModel().getData().getDescriptions(this.model.getRep());
        descs = descs.openSet(range);
        this.model.setSegment((Collection)descs);
    }

    protected IHasPositionSet<? extends IHasPosition> getPositions() {
        IDescSet segment = this.model.getSegment();
        if (segment.isEmpty()) {
            return new HasPositionSet();
        }
        SimplePosition p = new SimplePosition((IHasPosition)this.model.getSegment());
        return new HasPositionSet(Collections.singleton(p));
    }
}

