/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.frameworkadmin.equinox;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxBundlesState;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxManipulatorImpl;
import org.eclipse.equinox.internal.frameworkadmin.equinox.Log;
import org.eclipse.equinox.internal.frameworkadmin.equinox.Messages;
import org.eclipse.equinox.internal.frameworkadmin.equinox.utils.FileUtils;
import org.eclipse.equinox.internal.frameworkadmin.utils.Utils;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class EquinoxFwConfigFileParser {
    private static final String CONFIG_DIR = "@config.dir/";
    private static final String KEY_ECLIPSE_PROV_CACHE = "eclipse.p2.cache";
    private static final String KEY_ECLIPSE_PROV_DATA_AREA = "eclipse.p2.data.area";
    private static final String KEY_ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL = "org.eclipse.equinox.simpleconfigurator.configUrl";
    private static final String KEY_OSGI_BUNDLES = "osgi.bundles";
    private static final String KEY_OSGI_FRAMEWORK = "osgi.framework";
    private static final String KEY_OSGI_LAUNCHER_PATH = "osgi.launcherPath";
    private static final String[] PATHS = new String[]{"osgi.launcherPath", "eclipse.p2.cache"};
    private static boolean DEBUG = false;
    private static String USE_REFERENCE_STRING = null;

    public EquinoxFwConfigFileParser(BundleContext context) {
        if (context != null) {
            USE_REFERENCE_STRING = context.getProperty("org.eclipse.equinox.frameworkadmin.equinox.useReference");
        }
    }

    private static String getCommandLine(BundleInfo bundleInfo, URL baseUrl) {
        String location = bundleInfo.getLocation();
        if (location == null) {
            return null;
        }
        boolean useReference = true;
        if (location.startsWith("file:") && USE_REFERENCE_STRING != null && USE_REFERENCE_STRING.equals("false")) {
            useReference = false;
        }
        try {
            new URL(location);
        }
        catch (MalformedURLException e) {
            Log.log(1, "EquinoxFwConfigFileParser.getCommandLine():bundleInfo=" + bundleInfo, e);
        }
        if (useReference && !location.startsWith("reference:")) {
            location = "reference:" + location;
        }
        int startLevel = bundleInfo.getStartLevel();
        boolean toBeStarted = bundleInfo.isMarkedAsStarted();
        StringBuffer sb = new StringBuffer();
        sb.append(location);
        if (startLevel == -1 && !toBeStarted) {
            return sb.toString();
        }
        sb.append('@');
        if (startLevel != -1) {
            sb.append(startLevel);
        }
        if (toBeStarted) {
            sb.append(":start");
        }
        return sb.toString();
    }

    private static Properties getConfigProps(BundleInfo[] bInfos, ConfigData configData, LauncherData launcherData, boolean relative, File fwJar) {
        String launcherName;
        File launcher;
        Properties props = new Properties();
        if (configData.getInitialBundleStartLevel() != -1) {
            props.setProperty("osgi.bundles.defaultStartLevel", Integer.toString(configData.getInitialBundleStartLevel()));
        }
        if (configData.getBeginingFwStartLevel() != -1) {
            props.setProperty("osgi.startLevel", Integer.toString(configData.getBeginingFwStartLevel()));
        }
        if ((launcher = launcherData.getLauncher()) != null && (launcherName = launcher.getName()).endsWith(".exe")) {
            props.setProperty("osgi.launcherIni", launcherName.substring(0, launcherName.lastIndexOf(".exe")));
            props.setProperty(KEY_OSGI_LAUNCHER_PATH, launcher.getParentFile().getAbsolutePath());
        }
        String fwJarSt = null;
        try {
            if (fwJar != null) {
                fwJarSt = fwJar.toURL().toExternalForm();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (bInfos != null) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < bInfos.length) {
                EquinoxFwConfigFileParser.normalizeLocation(bInfos[i]);
                if (fwJarSt == null || !fwJarSt.equals(bInfos[i].getLocation())) {
                    sb.append(EquinoxFwConfigFileParser.getCommandLine(bInfos[i], null));
                    if (i + 1 < bInfos.length) {
                        sb.append(',');
                    }
                }
                ++i;
            }
            props.setProperty(KEY_OSGI_BUNDLES, sb.toString());
        }
        props = Utils.appendProperties((Properties)props, (Properties)configData.getFwIndependentProps());
        props = Utils.appendProperties((Properties)props, (Properties)configData.getFwDependentProps());
        if (fwJarSt != null) {
            props.setProperty(KEY_OSGI_FRAMEWORK, fwJarSt);
        } else {
            ((Hashtable)props).remove(KEY_OSGI_FRAMEWORK);
        }
        return props;
    }

    private static boolean getMarkedAsStartedFormat(String msg, String original) {
        if (msg == null) {
            return false;
        }
        int colon = (msg = msg.trim()).indexOf(":");
        if (colon > -1) {
            return msg.substring(colon + 1).equals("start");
        }
        return msg.equals("start");
    }

    private static int getStartLevel(String msg, String original) {
        if (msg == null) {
            return -1;
        }
        int colon = (msg = msg.trim()).indexOf(":");
        if (colon > 0) {
            try {
                return Integer.parseInt(msg.substring(0, colon));
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    static boolean isFwDependent(String key) {
        return key.startsWith("osgi.");
    }

    private static void normalizeLocation(BundleInfo bInfo) {
        String location = bInfo.getLocation();
        try {
            if (location.startsWith("file:")) {
                bInfo.setLocation(new URL(location).toExternalForm());
            } else {
                bInfo.setLocation(new File(location).toURL().toExternalForm());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private static void setInstallingBundles(Manipulator manipulator, String value) throws NumberFormatException {
        ConfigData configData = manipulator.getConfigData();
        if (value != null) {
            String[] bInfoStrings = Utils.getTokens((String)value, (String)",");
            int i = 0;
            while (i < bInfoStrings.length) {
                String token = bInfoStrings[i].trim();
                int indexI = (token = FileUtils.getRealLocation(manipulator, token, false).trim()).indexOf("@");
                String location = indexI == -1 ? token : token.substring(0, indexI);
                String realLocation = FileUtils.getEclipseRealLocation(manipulator, location);
                String slAndFlag = indexI > -1 ? token.substring(indexI + 1) : null;
                boolean markedAsStarted = EquinoxFwConfigFileParser.getMarkedAsStartedFormat(slAndFlag, token);
                int startLevel = EquinoxFwConfigFileParser.getStartLevel(slAndFlag, token);
                if (realLocation != null) {
                    configData.addBundle(new BundleInfo(realLocation, startLevel, markedAsStarted));
                } else {
                    configData.addBundle(new BundleInfo(location, null, null, startLevel, markedAsStarted));
                }
                ++i;
            }
        }
    }

    public void readFwConfig(Manipulator manipulator, File inputFile) throws IOException {
        if (inputFile.isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.exception_inputFileIsDirectory, (Object)inputFile));
        }
        ConfigData configData = manipulator.getConfigData();
        LauncherData launcherData = manipulator.getLauncherData();
        configData.initialize();
        Properties props = EquinoxFwConfigFileParser.loadProperties(inputFile);
        URL rootURL = launcherData.getLauncher() != null ? launcherData.getLauncher().getParentFile().toURL() : null;
        Properties sharedConfigProperties = this.getSharedConfiguration(props.getProperty("osgi.sharedConfiguration.area"), EquinoxFwConfigFileParser.getOSGiInstallArea(manipulator.getLauncherData()));
        if (sharedConfigProperties != null) {
            ((Hashtable)sharedConfigProperties).putAll(props);
            props = sharedConfigProperties;
        }
        String launcherName = null;
        String launcherPath = null;
        configData.setBundles(null);
        File fwJar = null;
        if (props.getProperty(KEY_OSGI_FRAMEWORK) != null) {
            props.setProperty(KEY_OSGI_FRAMEWORK, EquinoxManipulatorImpl.makeAbsolute(props.getProperty(KEY_OSGI_FRAMEWORK), EquinoxFwConfigFileParser.getOSGiInstallArea(launcherData).toURL()));
            String fwJarString = props.getProperty(KEY_OSGI_FRAMEWORK);
            if (fwJarString != null) {
                fwJar = new File(new URL(fwJarString).getFile());
                launcherData.setFwJar(fwJar);
                configData.addBundle(new BundleInfo(fwJarString));
            }
        }
        props = EquinoxFwConfigFileParser.makeAbsolute(props, rootURL, fwJar, inputFile.getParentFile(), EquinoxFwConfigFileParser.getOSGiInstallArea(manipulator.getLauncherData()));
        Enumeration enumeration = ((Hashtable)props).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = props.getProperty(key);
            if (key.equals("osgi.bundles.defaultStartLevel")) {
                configData.setInitialBundleStartLevel(Integer.parseInt(value));
                continue;
            }
            if (key.equals("osgi.startLevel")) {
                configData.setBeginningFwStartLevel(Integer.parseInt(value));
                continue;
            }
            if (key.equals(KEY_OSGI_BUNDLES)) {
                EquinoxFwConfigFileParser.setInstallingBundles(manipulator, value);
                continue;
            }
            if (EquinoxFwConfigFileParser.isFwDependent(key)) {
                configData.setFwDependentProp(key, value);
            } else {
                configData.setFwIndependentProp(key, value);
            }
            if (key.equals("osgi.launcherIni") && launcherData.getLauncher() == null) {
                launcherName = value;
            }
            if (!key.equals(KEY_OSGI_LAUNCHER_PATH) || launcherData.getLauncher() != null) continue;
            launcherPath = value;
        }
        if (launcherName != null && launcherPath != null) {
            launcherData.setLauncher(new File(launcherPath, String.valueOf(launcherName) + ".exe"));
        }
        Log.log(3, NLS.bind((String)Messages.log_configFile, (Object)inputFile.getAbsolutePath()));
    }

    private static Properties loadProperties(File inputFile) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(inputFile);
            props.load(is);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {
                Log.log(2, NLS.bind((String)Messages.log_failed_reading_properties, (Object)inputFile));
            }
            is = null;
            throw throwable;
        }
        try {
            ((InputStream)is).close();
        }
        catch (IOException iOException) {
            Log.log(2, NLS.bind((String)Messages.log_failed_reading_properties, (Object)inputFile));
        }
        is = null;
        return props;
    }

    private File findSharedConfigIniFile(URL rootURL, String sharedConfigurationArea) {
        File sharedConfigurationFolder;
        URL sharedConfigurationURL = null;
        try {
            sharedConfigurationURL = new URL(sharedConfigurationArea);
        }
        catch (MalformedURLException malformedURLException) {
            Log.log(2, NLS.bind((String)Messages.log_shared_config_url, (Object)sharedConfigurationArea));
            return null;
        }
        if (!sharedConfigurationURL.getPath().startsWith("/")) {
            if (!rootURL.getProtocol().equals(sharedConfigurationURL.getProtocol())) {
                Log.log(2, NLS.bind((String)Messages.log_shared_config_relative_url, (Object)rootURL.toExternalForm(), (Object)sharedConfigurationArea));
                return null;
            }
            try {
                sharedConfigurationURL = new URL(rootURL, sharedConfigurationArea);
            }
            catch (MalformedURLException malformedURLException) {
                Log.log(2, NLS.bind((String)Messages.log_shared_config_relative_url, (Object)rootURL.toExternalForm(), (Object)sharedConfigurationArea));
                return null;
            }
        }
        if (!(sharedConfigurationFolder = new File(sharedConfigurationURL.getPath())).isDirectory()) {
            Log.log(2, NLS.bind((String)Messages.log_shared_config_file_missing, (Object)sharedConfigurationFolder));
            return null;
        }
        File sharedConfigIni = new File(sharedConfigurationFolder, "config.ini");
        if (!sharedConfigIni.exists()) {
            Log.log(2, NLS.bind((String)Messages.log_shared_config_file_missing, (Object)sharedConfigIni));
            return null;
        }
        return sharedConfigIni;
    }

    private static Properties makeRelative(Properties props, URL rootURL, File fwJar, File configArea, File osgiInstallArea) throws IOException {
        File parent;
        String value;
        String url;
        int i = 0;
        while (i < PATHS.length) {
            String path = props.getProperty(PATHS[i]);
            if (path != null) {
                ((Hashtable)props).put(PATHS[i], EquinoxManipulatorImpl.makeRelative(path, rootURL.getFile()));
            }
            ++i;
        }
        if (props.getProperty(KEY_OSGI_FRAMEWORK) != null && osgiInstallArea != null) {
            ((Hashtable)props).put(KEY_OSGI_FRAMEWORK, EquinoxManipulatorImpl.makeRelative(props.getProperty(KEY_OSGI_FRAMEWORK), osgiInstallArea.toURL()));
        }
        if (props.getProperty(KEY_ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL) != null) {
            ((Hashtable)props).put(KEY_ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL, EquinoxManipulatorImpl.makeRelative(props.getProperty(KEY_ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL), configArea.toURL()));
        }
        if (props.getProperty(KEY_ECLIPSE_PROV_DATA_AREA) != null && (url = props.getProperty(KEY_ECLIPSE_PROV_DATA_AREA)) != null) {
            String result = EquinoxManipulatorImpl.makeRelative(url, configArea.toURL());
            if (result.startsWith("file:../..")) {
                result = url;
            } else if (!result.equals(url) && result.startsWith("file:")) {
                result = CONFIG_DIR + result.substring(5);
            }
            ((Hashtable)props).put(KEY_ECLIPSE_PROV_DATA_AREA, result);
        }
        if ((value = props.getProperty(KEY_OSGI_BUNDLES)) != null && fwJar != null && (parent = fwJar.getParentFile()) != null) {
            props.setProperty(KEY_OSGI_BUNDLES, EquinoxManipulatorImpl.makeArrayRelative(value, parent.toURL()));
        }
        return props;
    }

    private static Properties makeAbsolute(Properties props, URL rootURL, File fwJar, File configArea, File osgiInstallArea) throws IOException {
        File parent;
        String value;
        String url;
        int i = 0;
        while (i < PATHS.length) {
            String path = props.getProperty(PATHS[i]);
            if (path != null) {
                props.setProperty(PATHS[i], EquinoxManipulatorImpl.makeAbsolute(path, rootURL.getFile()));
            }
            ++i;
        }
        if (props.getProperty(KEY_ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL) != null) {
            ((Hashtable)props).put(KEY_ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL, EquinoxManipulatorImpl.makeAbsolute(props.getProperty(KEY_ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL), configArea.toURL()));
        }
        if (props.getProperty(KEY_ECLIPSE_PROV_DATA_AREA) != null && (url = props.getProperty(KEY_ECLIPSE_PROV_DATA_AREA)) != null) {
            if (url.startsWith(CONFIG_DIR)) {
                url = "file:" + url.substring(CONFIG_DIR.length());
            }
            ((Hashtable)props).put(KEY_ECLIPSE_PROV_DATA_AREA, EquinoxManipulatorImpl.makeAbsolute(url, configArea.toURL()));
        }
        if ((value = props.getProperty(KEY_OSGI_BUNDLES)) != null && fwJar != null && (parent = fwJar.getParentFile()) != null) {
            props.setProperty(KEY_OSGI_BUNDLES, EquinoxManipulatorImpl.makeArrayAbsolute(value, parent.toURL()));
        }
        return props;
    }

    public static File getOSGiInstallArea(LauncherData launcherData) {
        if (launcherData == null) {
            return null;
        }
        String[] args = launcherData.getProgramArgs();
        if (args == null) {
            return null;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-startup") && i + 1 < args.length && args[i + 1].charAt(1) != '-') {
                return EquinoxFwConfigFileParser.fromOSGiJarToOSGiInstallArea(args[i + 1]);
            }
            ++i;
        }
        if (launcherData.getFwJar() != null) {
            return EquinoxFwConfigFileParser.fromOSGiJarToOSGiInstallArea(launcherData.getFwJar().getAbsolutePath());
        }
        if (launcherData.getLauncher() != null) {
            return launcherData.getLauncher().getParentFile();
        }
        return null;
    }

    private static File fromOSGiJarToOSGiInstallArea(String path) {
        IPath parentFolder = new Path(path).removeLastSegments(1);
        if (parentFolder.lastSegment().equals("plugins")) {
            return parentFolder.removeLastSegments(1).toFile();
        }
        return parentFolder.toFile();
    }

    public void saveFwConfig(BundleInfo[] bInfos, Manipulator manipulator, boolean backup, boolean relative) throws IOException {
        ConfigData configData = manipulator.getConfigData();
        LauncherData launcherData = manipulator.getLauncherData();
        File fwJar = EquinoxBundlesState.getFwJar(launcherData, configData);
        launcherData.setFwJar(fwJar);
        File outputFile = launcherData.getFwConfigLocation();
        if (outputFile.exists()) {
            if (outputFile.isFile()) {
                if (!outputFile.getName().equals("config.ini")) {
                    throw new IllegalStateException(NLS.bind((String)Messages.exception_fwConfigLocationName, (Object)outputFile.getAbsolutePath(), (Object)"config.ini"));
                }
            } else {
                outputFile = new File(outputFile, "config.ini");
            }
        } else if (!outputFile.getName().equals("config.ini")) {
            if (!outputFile.mkdir()) {
                throw new IOException(NLS.bind((String)Messages.exception_failedToCreateDir, (Object)outputFile));
            }
            outputFile = new File(outputFile, "config.ini");
        }
        String header = "This configuration file was written by: " + this.getClass().getName();
        Properties configProps = EquinoxFwConfigFileParser.getConfigProps(bInfos, configData, launcherData, relative, fwJar);
        if (configProps == null || ((Hashtable)configProps).size() == 0) {
            Log.log(2, (Object)this, "saveFwConfig() ", Messages.log_configProps);
            return;
        }
        Utils.createParentDir((File)outputFile);
        if (DEBUG) {
            Utils.printoutProperties((PrintStream)System.out, (String)"configProps", (Properties)configProps);
        }
        if (backup && outputFile.exists()) {
            File dest = Utils.getSimpleDataFormattedFile((File)outputFile);
            if (!outputFile.renameTo(dest)) {
                throw new IOException(NLS.bind((String)Messages.exception_failedToRename, (Object)outputFile, (Object)dest));
            }
            Log.log(3, (Object)this, "saveFwConfig()", NLS.bind((String)Messages.log_renameSuccessful, (Object)outputFile, (Object)dest));
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputFile);
            configProps = EquinoxFwConfigFileParser.makeRelative(configProps, launcherData.getLauncher().getParentFile().toURL(), fwJar, outputFile.getParentFile(), EquinoxFwConfigFileParser.getOSGiInstallArea(manipulator.getLauncherData()));
            this.filterPropertiesFromSharedArea(configProps, launcherData);
            configProps.store(out, header);
            Log.log(3, NLS.bind((String)Messages.log_fwConfigSave, (Object)outputFile));
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            out = null;
        }
    }

    private void filterPropertiesFromSharedArea(Properties configProps, LauncherData launcherData) {
        Properties sharedConfigProperties = this.getSharedConfiguration(configProps.getProperty("osgi.sharedConfiguration.area"), EquinoxFwConfigFileParser.getOSGiInstallArea(launcherData));
        if (sharedConfigProperties == null) {
            return;
        }
        Enumeration<?> keys = configProps.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String sharedValue = sharedConfigProperties.getProperty(key);
            if (sharedValue == null || !this.equalsIgnoringSeparators(sharedValue, configProps.getProperty(key))) continue;
            ((Hashtable)configProps).remove(key);
        }
    }

    private boolean equalsIgnoringSeparators(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        StringBuffer sb1 = new StringBuffer(s1);
        StringBuffer sb2 = new StringBuffer(s2);
        this.canonicalizePathsForComparison(sb1);
        this.canonicalizePathsForComparison(sb2);
        return sb1.toString().equals(sb2.toString());
    }

    private void canonicalizePathsForComparison(StringBuffer s) {
        String[] tokens = new String[]{"\\\\", "\\", "//", "/"};
        int t = 0;
        while (t < tokens.length) {
            int idx = s.length();
            int i = s.length();
            while (i != 0 && idx != -1) {
                idx = s.toString().lastIndexOf(tokens[t], idx);
                if (idx != -1) {
                    s.replace(idx, idx + tokens[t].length(), "^");
                }
                --i;
            }
            ++t;
        }
    }

    private Properties getSharedConfiguration(String sharedConfigurationArea, File baseFile) {
        File sharedConfigIni;
        if (sharedConfigurationArea == null) {
            return null;
        }
        try {
            sharedConfigIni = this.findSharedConfigIniFile(baseFile.toURL(), sharedConfigurationArea);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (sharedConfigIni != null && sharedConfigIni.exists()) {
            try {
                return EquinoxFwConfigFileParser.loadProperties(sharedConfigIni);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }
}

