/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.metadata;

import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.osgi.framework.Version;

public class ProvidedCapability {
    private final String name;
    private final String namespace;
    private final Version version;

    ProvidedCapability(String namespace, String name, Version version) {
        Assert.isNotNull((Object)namespace);
        Assert.isNotNull((Object)name);
        this.namespace = namespace;
        this.name = name;
        this.version = version == null ? Version.emptyVersion : version;
    }

    public boolean equals(Object other) {
        if (other instanceof ProvidedCapability) {
            ProvidedCapability otherCapability = (ProvidedCapability)other;
            return otherCapability.namespace.equals(this.namespace) && otherCapability.name.equals(this.name) && otherCapability.version.equals((Object)this.version);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.namespace.hashCode() * this.name.hashCode() * this.version.hashCode();
    }

    public boolean isSatisfiedBy(RequiredCapability candidate) {
        if (this.getName() == null || !this.getName().equals(candidate.getName())) {
            return false;
        }
        if (this.getNamespace() == null || !this.getNamespace().equals(candidate.getNamespace())) {
            return false;
        }
        return candidate.getRange().isIncluded(this.version);
    }

    public String toString() {
        return String.valueOf(this.namespace) + '/' + this.name + '/' + this.version;
    }
}

