/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.colloc.rules;

import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.colloc.IColloc;
import edu.mit.parsing.core.rep.colloc.problems.RepeatedMWEProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleMWERule
extends AbstractBuildRule {
    public SingleMWERule() {
        super(CollocRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        HashMap<IDescSet, HashSet<IDesc>> repeated = new HashMap<IDescSet, HashSet<IDesc>>();
        for (IDesc mweDesc : model.getData().getDescriptions(CollocRep.getInstance())) {
            IColloc mwe = (IColloc)mweDesc.getData();
            HashSet<IDesc> mweDescs = (HashSet<IDesc>)repeated.get(mwe.getTokens());
            if (mweDescs == null) {
                mweDescs = new HashSet<IDesc>(1);
                repeated.put(mwe.getTokens(), mweDescs);
            }
            mweDescs.add(mweDesc);
        }
        HasPositionSet result = new HasPositionSet();
        for (Set d : repeated.values()) {
            if (d.size() <= 1) continue;
            result.add((Object)new RepeatedMWEProblem(d, this.getID()));
        }
        return result;
    }
}

