/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.stem.problems;

import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collections;

public class InappropriateStemProblem
extends StoryProblem {
    public static final String ID = "edu.mit.parsing.core.problem.inappropriateStem";

    public InappropriateStemProblem(IDesc stemDesc, String buildRuleID) {
        super(POSRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("Inappropriate Stem");
        this.setDescs(Collections.singleton(stemDesc));
        this.setSeverity(2);
        IDescSet stemDescs = this.getDescs().getDescriptions(StemRep.getInstance());
        if (stemDescs.isEmpty()) {
            throw new IllegalArgumentException();
        }
        stemDesc = (IDesc)stemDescs.first();
        this.setPosition((IHasPosition)stemDesc);
        IStem stem = (IStem)stemDesc.getData();
        IBaseToken tok = (IBaseToken)stem.getWord().getData();
        StringBuilder sb = new StringBuilder();
        sb.append("The word '");
        sb.append(tok.getSurface());
        sb.append("' has a stem when it should not; please delete it");
        this.setDescription(sb.toString());
    }
}

