/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.dialogs;

import edu.mit.jwi.IDictionary;
import edu.mit.jwi.StringMatcher;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.story.ui.WorkbenchUtils;
import edu.mit.story.ui.viewers.ITableItemConfigurer;
import edu.mit.story.ui.viewers.ListViewerComponent;
import edu.mit.story.ui.widgets.CheckboxEnumGroup;
import edu.mit.wordnet.ui.WordnetUIMessages;
import edu.mit.wordnet.ui.dialogs.WordConfigurer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordSearchComponent
extends Composite {
    public static final String underscore = "_";
    public static final Pattern wsPattern = Pattern.compile("\\s+");
    public static final Pattern dashPattern = Pattern.compile("-+");
    public static final Pattern underPattern = Pattern.compile("_+");
    private final String initialPattern;
    private final Set<POS> initialPOS;
    private Text wordFilter;
    private CheckboxEnumGroup<POS> fPOSSelect;
    private Text keywordFilter;
    private Label fProgressLabel;
    private ListViewerComponent<IWord> fViewer;
    private final IDictionary dict;
    private List<IWord> fHistory;
    private SearchJob fCurrentSearchJob;

    public WordSearchComponent(Composite parent, int style, String srchPattern, Set<POS> srchPOS, IDictionary dict, List<IWord> historyWords) {
        super(parent, style);
        this.dict = dict;
        this.fHistory = historyWords == null || historyWords.isEmpty() ? Collections.emptyList() : historyWords;
        this.setFont(parent.getFont());
        this.initialPattern = srchPattern == null ? "" : srchPattern;
        this.initialPOS = srchPOS == null || srchPOS.isEmpty() ? Collections.singleton(POS.NOUN) : srchPOS;
        this.createContent();
        this.startSearch();
    }

    protected void createContent() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        this.wordFilter = new Text((Composite)this, 0x800880);
        this.wordFilter.setMessage("type word forms here");
        this.wordFilter.setFont(this.getFont());
        this.wordFilter.setLayoutData((Object)gd);
        this.wordFilter.setText(this.initialPattern);
        this.wordFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WordSearchComponent.this.startSearch();
            }
        });
        this.wordFilter.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    WordSearchComponent.this.keywordFilter.setFocus();
                }
            }
        });
        this.fPOSSelect = new CheckboxEnumGroup(POS.class);
        this.fPOSSelect.setValues(this.initialPOS);
        this.fPOSSelect.createComposite((Composite)this, 0);
        this.fPOSSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WordSearchComponent.this.startSearch();
            }
        });
        gd = new GridData(4, 4, true, false);
        this.keywordFilter = new Text((Composite)this, 0x800880);
        this.keywordFilter.setMessage("type keywords here");
        this.keywordFilter.setFont(this.getFont());
        this.keywordFilter.setLayoutData((Object)new GridData(768));
        this.keywordFilter.setText("");
        this.keywordFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WordSearchComponent.this.startSearch();
            }
        });
        this.keywordFilter.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000002: {
                        if (WordSearchComponent.this.fViewer.getTable().getItemCount() <= 0) break;
                        WordSearchComponent.this.fViewer.setFocus();
                        WordSearchComponent.this.fViewer.getTable().setSelection(0);
                        break;
                    }
                    case 0x1000001: {
                        WordSearchComponent.this.wordFilter.setFocus();
                    }
                }
            }
        });
        gd = new GridData(768);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        Composite panel = new Composite((Composite)this, 0);
        panel.setLayoutData((Object)gd);
        panel.setLayout((Layout)layout);
        gd = new GridData(768);
        Label label = new Label(panel, 0);
        label.setText(WordnetUIMessages.DIALOG_MESSAGE_WordSearchResult);
        label.setFont(this.getFont());
        label.setLayoutData((Object)gd);
        gd = new GridData(768);
        this.fProgressLabel = new Label(panel, 0);
        this.fProgressLabel.setAlignment(131072);
        this.fProgressLabel.setText("");
        this.fProgressLabel.setFont(this.getFont());
        this.fProgressLabel.setLayoutData((Object)gd);
        gd = new GridData(1808);
        int style = 0x800B00;
        this.fViewer = new ListViewerComponent((Composite)this, style, (ITableItemConfigurer)new WordConfigurer());
        this.fViewer.setLayoutData((Object)gd);
        this.fViewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 & WordSearchComponent.this.fViewer.getTable().getSelectionIndex() == 0) {
                    WordSearchComponent.this.keywordFilter.setFocus();
                }
                if (WordSearchComponent.this.fViewer.getSeparatorIndex() > 0) {
                    if (e.keyCode == 0x1000001 & WordSearchComponent.this.fViewer.getTable().getSelectionIndex() == WordSearchComponent.this.fViewer.getSeparatorIndex() + 1) {
                        WordSearchComponent.this.fViewer.getTable().setSelection(WordSearchComponent.this.fViewer.getSeparatorIndex());
                    }
                    if (e.keyCode == 0x1000002 & WordSearchComponent.this.fViewer.getTable().getSelectionIndex() == WordSearchComponent.this.fViewer.getSeparatorIndex() - 1) {
                        WordSearchComponent.this.fViewer.getTable().setSelection(WordSearchComponent.this.fViewer.getSeparatorIndex());
                    }
                }
            }
        });
        this.fViewer.setHistory(this.fHistory);
        this.wordFilter.setFocus();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fViewer.addSelectionListener(listener);
        this.wordFilter.addSelectionListener(listener);
    }

    public void startSearch() {
        this.stopSearch();
        this.fCurrentSearchJob = new SearchJob(this.wordFilter.getText(), this.keywordFilter.getText(), this.fPOSSelect.getValues());
        this.fCurrentSearchJob.schedule();
    }

    public void stopSearch() {
        if (this.fCurrentSearchJob != null) {
            this.fCurrentSearchJob.stop();
        }
    }

    public boolean selectionExists() {
        return this.fViewer.selectionExists();
    }

    public IWord getResult() {
        return (IWord)this.fViewer.getSelection();
    }

    static /* synthetic */ List access$3(WordSearchComponent wordSearchComponent) {
        return wordSearchComponent.fHistory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class IndexWordComparator
    implements Comparator<IIndexWord> {
        protected IndexWordComparator() {
        }

        @Override
        public int compare(IIndexWord o1, IIndexWord o2) {
            int c = o1.getLemma().compareTo(o2.getLemma());
            if (c != 0) {
                return c;
            }
            POS p1 = o1.getPOS();
            POS p2 = o2.getPOS();
            return p1.compareTo((Enum)p2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SearchJob
    extends Job {
        boolean shouldCancel;
        StringMatcher[] matchers;
        StringMatcher keyMatcher;
        final List<Iterator<IIndexWord>> itrs;
        char one;

        public SearchJob(String pattern) {
            this(pattern, "", null);
        }

        public SearchJob(String pattern, String filter, Set<POS> pos) {
            super(WordnetUIMessages.JOB_NAME_Search);
            this.shouldCancel = false;
            this.one = (char)49;
            if (pos == null) {
                throw new NullPointerException();
            }
            String key = this.generateMatchers(pattern);
            this.itrs = this.generateIterators(pos, key);
            if (!filter.endsWith("*") || !filter.endsWith("?")) {
                filter = String.valueOf(filter) + "*";
            }
            if (!filter.startsWith("*") || !filter.startsWith("?")) {
                filter = "*" + filter;
            }
            this.keyMatcher = new StringMatcher(filter, true, false);
        }

        protected String generateMatchers(String pattern) {
            if (pattern == null) {
                throw new NullPointerException();
            }
            if ((pattern = pattern.toLowerCase()).length() > 0 && !pattern.endsWith("*")) {
                pattern = String.valueOf(pattern) + "*";
            }
            pattern = wsPattern.matcher(pattern).replaceAll(WordSearchComponent.underscore);
            HashSet<String> strs = new HashSet<String>();
            strs.add(pattern);
            String altPattern = dashPattern.matcher(pattern).replaceAll(WordSearchComponent.underscore);
            String[] parts = underPattern.split(altPattern, -1);
            if (parts.length > 1) {
                StringBuilder sb = new StringBuilder(altPattern.length());
                int max = (int)Math.pow(2.0, parts.length - 1);
                int i = 0;
                while (i < max) {
                    String mask = Integer.toBinaryString(i);
                    sb.setLength(0);
                    int j = 0;
                    j = 0;
                    while (j < mask.length()) {
                        sb.append(parts[j]);
                        if (mask.charAt(j) == this.one) {
                            sb.append(WordSearchComponent.underscore);
                        }
                        ++j;
                    }
                    sb.append(parts[j]);
                    strs.add(sb.toString());
                    ++i;
                }
            }
            ArrayList<StringMatcher> result = new ArrayList<StringMatcher>(strs.size());
            for (String str : strs) {
                result.add(new StringMatcher(str, true, false));
            }
            this.matchers = result.toArray(new StringMatcher[result.size()]);
            return parts[0];
        }

        protected List<Iterator<IIndexWord>> generateIterators(Set<POS> pos, String startKey) {
            ArrayList<Iterator<IIndexWord>> result = new ArrayList<Iterator<IIndexWord>>(pos.size());
            for (POS p : pos) {
                result.add(WordSearchComponent.this.dict.getIndexWordPatternIterator(p, String.valueOf(startKey) + "*"));
            }
            return result;
        }

        protected boolean matches(IWord word) {
            boolean lemmaMatches = false;
            String lemma = word.getLemma();
            StringMatcher[] stringMatcherArray = this.matchers;
            int n = this.matchers.length;
            int n2 = 0;
            while (n2 < n) {
                StringMatcher m = stringMatcherArray[n2];
                if (m.match(lemma)) {
                    lemmaMatches = true;
                    break;
                }
                ++n2;
            }
            if (!lemmaMatches) {
                return false;
            }
            for (IWord syn : word.getSynset().getWords()) {
                if (!this.keyMatcher.match(syn.getLemma())) continue;
                return true;
            }
            if (this.keyMatcher.match(word.getSynset().getGloss())) {
                return true;
            }
            return this.keyMatcher.match(word.getSenseKey().toString());
        }

        protected IStatus restoreLabel(IStatus status) {
            WordSearchComponent.this.fViewer.finalizeDisplay();
            WorkbenchUtils.runInUIThread((Runnable)new Runnable(){

                public void run() {
                    if (WordSearchComponent.this.fProgressLabel != null && !WordSearchComponent.this.fProgressLabel.isDisposed()) {
                        WordSearchComponent.this.fProgressLabel.setText("");
                    }
                }
            });
            return status;
        }

        /*
         * Unable to fully structure code
         */
        protected IStatus run(IProgressMonitor monitor) {
            WorkbenchUtils.runInUIThread((Runnable)new Runnable(){

                public void run() {
                    if (WordSearchComponent.this.fProgressLabel != null && !WordSearchComponent.this.fProgressLabel.isDisposed()) {
                        WordSearchComponent.this.fProgressLabel.setText("Searching...");
                    }
                }
            });
            WordSearchComponent.access$1(WordSearchComponent.this).clearHistory();
            WordSearchComponent.access$1(WordSearchComponent.this).clearResults();
            newHistory = new ArrayList<IWord>(WordSearchComponent.access$3(WordSearchComponent.this).size());
            for (IWord word : WordSearchComponent.access$3(WordSearchComponent.this)) {
                if (!this.matches(word)) continue;
                newHistory.add(word);
            }
            WordSearchComponent.access$1(WordSearchComponent.this).setHistory(newHistory);
            if (this.shouldCancel) {
                return this.restoreLabel(Status.CANCEL_STATUS);
            }
            wordQueue = new ArrayList<IWord>();
            block1: while (!this.itrs.isEmpty()) {
                if (this.shouldCancel) break;
                ii = this.itrs.iterator();
                while (ii.hasNext()) {
                    itr = ii.next();
                    if (itr.hasNext()) ** GOTO lbl33
                    ii.remove();
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        nextIdxWord = itr.next();
                        for (IWordID wordId : nextIdxWord.getWordIDs()) {
                            word = WordSearchComponent.access$0(WordSearchComponent.this).getWord(wordId);
                            if (!this.matches(word)) continue;
                            wordQueue.add(word);
                        }
                        if (this.shouldCancel) break block1;
                        if (WordSearchComponent.access$1(WordSearchComponent.this).canWait() && wordQueue.size() < 10) continue;
                        WordSearchComponent.access$1(WordSearchComponent.this).appendResultItems(wordQueue);
                        wordQueue.clear();
lbl33:
                        // 3 sources

                        ** while (itr.hasNext())
                    }
lbl34:
                    // 1 sources

                }
            }
            if (!this.shouldCancel) {
                WordSearchComponent.access$1(WordSearchComponent.this).appendResultItems(wordQueue);
            }
            return this.shouldCancel != false ? this.restoreLabel(Status.CANCEL_STATUS) : this.restoreLabel(Status.OK_STATUS);
        }

        public void stop() {
            this.shouldCancel = true;
            this.cancel();
        }
    }
}

