/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.RemoteResource;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.CompareRemoteResourcesAction;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.dialogs.SvnDialog;
import org.tigris.subversion.subclipse.ui.operations.ShowDifferencesAsUnifiedDiffOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class DifferencesDialog
extends SvnDialog {
    private ISVNResource[] remoteResources;
    private String title;
    private IWorkbenchPart targetPart;
    private ISVNResource fromResource;
    private ISVNResource toResource;
    private Button compareButton;
    private Button diffButton;
    private Text fileText;
    private Button browseButton;
    private Text fromUrlText;
    private Button fromHeadButton;
    private Text fromRevisionText;
    private Button fromLogButton;
    private Text toUrlText;
    private Button toHeadButton;
    private Text toRevisionText;
    private Button toLogButton;
    private Button okButton;
    private boolean success;
    private String fromRevision;
    private String toRevision;
    private boolean usePegRevision;

    public DifferencesDialog(Shell parentShell, String title, ISVNResource[] remoteResources, IWorkbenchPart targetPart) {
        super(parentShell, "DifferencesDialog");
        this.title = title;
        this.remoteResources = remoteResources;
        this.targetPart = targetPart;
        this.fromResource = this.remoteResources[0];
        if (this.remoteResources.length == 1 || this.remoteResources[1] == null) {
            this.remoteResources = new ISVNResource[2];
            this.remoteResources[0] = this.fromResource;
            this.remoteResources[1] = this.fromResource;
        }
        this.toResource = this.remoteResources[1];
    }

    protected Control createDialogArea(Composite parent) {
        if (this.title == null) {
            this.getShell().setText(Policy.bind("DifferencesDialog.compare"));
        } else {
            this.getShell().setText(this.title);
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Group fromGroup = new Group(composite, 0);
        fromGroup.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.compareFrom"));
        fromGroup.setLayout((Layout)new GridLayout(3, false));
        fromGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Label fromUrlLabel = new Label((Composite)fromGroup, 0);
        fromUrlLabel.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.url"));
        this.fromUrlText = new Text((Composite)fromGroup, 2048);
        this.fromUrlText.setLayoutData((Object)new GridData(768));
        this.fromUrlText.setText(this.remoteResources[0].getUrl().toString());
        Button bb = new Button((Composite)fromGroup, 8);
        bb.setText(Policy.bind("SwitchDialog.browse"));
        bb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseUrlDialog dialog = new ChooseUrlDialog(DifferencesDialog.this.getShell(), DifferencesDialog.this.fromResource.getResource());
                if (dialog.open() == 0 && dialog.getUrl() != null) {
                    DifferencesDialog.this.fromUrlText.setText(dialog.getUrl());
                }
            }
        });
        Composite fromRevisionGroup = new Composite((Composite)fromGroup, 0);
        GridLayout fromRevisionLayout = new GridLayout();
        fromRevisionLayout.numColumns = 3;
        fromRevisionLayout.marginWidth = 0;
        fromRevisionLayout.marginHeight = 0;
        fromRevisionGroup.setLayout((Layout)fromRevisionLayout);
        fromRevisionGroup.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.fromHeadButton = new Button(fromRevisionGroup, 32);
        this.fromHeadButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.head"));
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.fromHeadButton.setLayoutData((Object)data);
        Label fromRevisionLabel = new Label(fromRevisionGroup, 0);
        fromRevisionLabel.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.revision"));
        this.fromHeadButton.setSelection(true);
        this.fromRevisionText = new Text(fromRevisionGroup, 2048);
        this.fromRevisionText.setLayoutData((Object)new GridData(40, -1));
        this.fromRevisionText.setEnabled(false);
        this.fromLogButton = new Button(fromRevisionGroup, 8);
        this.fromLogButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.showLog"));
        this.fromLogButton.setEnabled(false);
        this.fromLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DifferencesDialog.this.showLog(e.getSource());
            }
        });
        Group toGroup = new Group(composite, 0);
        toGroup.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.compareTo"));
        toGroup.setLayout((Layout)new GridLayout(3, false));
        toGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Label toUrlLabel = new Label((Composite)toGroup, 0);
        toUrlLabel.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.url"));
        this.toUrlText = new Text((Composite)toGroup, 2048);
        this.toUrlText.setLayoutData((Object)new GridData(768));
        if (this.remoteResources.length < 2 || this.remoteResources[1] == null) {
            this.toUrlText.setText(this.remoteResources[0].getUrl().toString());
        } else {
            this.toUrlText.setText(this.remoteResources[1].getUrl().toString());
        }
        bb = new Button((Composite)toGroup, 8);
        bb.setText(Policy.bind("SwitchDialog.browse"));
        bb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resouce = null;
                resouce = DifferencesDialog.this.remoteResources.length < 2 || DifferencesDialog.this.remoteResources[1] == null ? DifferencesDialog.this.remoteResources[0].getResource() : DifferencesDialog.this.remoteResources[1].getResource();
                ChooseUrlDialog dialog = new ChooseUrlDialog(DifferencesDialog.this.getShell(), resouce);
                if (dialog.open() == 0 && dialog.getUrl() != null) {
                    DifferencesDialog.this.toUrlText.setText(dialog.getUrl());
                }
            }
        });
        Composite toRevisionGroup = new Composite((Composite)toGroup, 0);
        GridLayout toRevisionLayout = new GridLayout();
        toRevisionLayout.numColumns = 3;
        toRevisionLayout.marginWidth = 0;
        toRevisionLayout.marginHeight = 0;
        toRevisionGroup.setLayout((Layout)toRevisionLayout);
        toRevisionGroup.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.toHeadButton = new Button(toRevisionGroup, 32);
        this.toHeadButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.toHead"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.toHeadButton.setLayoutData((Object)data);
        Label toRevisionLabel = new Label(toRevisionGroup, 0);
        toRevisionLabel.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.toRevision"));
        this.toHeadButton.setSelection(true);
        this.toRevisionText = new Text(toRevisionGroup, 2048);
        this.toRevisionText.setLayoutData((Object)new GridData(40, -1));
        this.toRevisionText.setEnabled(false);
        this.toLogButton = new Button(toRevisionGroup, 8);
        this.toLogButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.showToLog"));
        this.toLogButton.setEnabled(false);
        this.toLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DifferencesDialog.this.showLog(e.getSource());
            }
        });
        if (this.fromRevision != null) {
            this.fromRevisionText.setText(this.fromRevision);
            this.fromRevisionText.setEnabled(true);
            this.fromLogButton.setEnabled(true);
            this.fromHeadButton.setSelection(false);
        }
        if (this.toRevision == null) {
            ISVNRemoteResource resource;
            if (this.fromResource == this.toResource) {
                if (this.fromRevision == null) {
                    resource = (ISVNRemoteResource)this.fromResource;
                    String fromRev = resource.getLastChangedRevision().toString();
                    int from = Integer.parseInt(fromRev);
                    this.toRevision = Integer.toString(--from);
                } else {
                    int from = Integer.parseInt(this.fromRevision);
                    this.toRevision = Integer.toString(--from);
                }
            } else {
                resource = (ISVNRemoteResource)this.toResource;
                this.toRevision = resource.getLastChangedRevision().toString();
            }
        }
        if (this.toRevision != null) {
            this.toRevisionText.setText(this.toRevision);
            this.toRevisionText.setEnabled(true);
            this.toLogButton.setEnabled(true);
            this.toHeadButton.setSelection(false);
        }
        Group fileGroup = new Group(composite, 0);
        fileGroup.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.compareType"));
        fileGroup.setLayout((Layout)new GridLayout(3, false));
        fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.compareButton = new Button((Composite)fileGroup, 16);
        this.compareButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.graphical"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.compareButton.setLayoutData((Object)data);
        this.diffButton = new Button((Composite)fileGroup, 16);
        this.diffButton.setText(Policy.bind("DifferencesDialog.diff"));
        this.compareButton.setSelection(true);
        this.fileText = new Text((Composite)fileGroup, 2048);
        data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 450;
        this.fileText.setLayoutData((Object)data);
        this.fileText.setEnabled(false);
        this.browseButton = new Button((Composite)fileGroup, 8);
        this.browseButton.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(DifferencesDialog.this.getShell(), 8192);
                dialog.setText(Policy.bind("ShowDifferencesAsUnifiedDiffDialog.fileDialogText"));
                dialog.setFileName("revision.diff");
                String outFile = dialog.open();
                if (outFile != null) {
                    DifferencesDialog.this.fileText.setText(outFile);
                }
            }
        });
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DifferencesDialog.this.setOkButtonStatus();
            }
        };
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DifferencesDialog.this.fromRevisionText.setEnabled(!DifferencesDialog.this.fromHeadButton.getSelection());
                DifferencesDialog.this.fromLogButton.setEnabled(!DifferencesDialog.this.fromHeadButton.getSelection());
                DifferencesDialog.this.toRevisionText.setEnabled(!DifferencesDialog.this.toHeadButton.getSelection());
                DifferencesDialog.this.toLogButton.setEnabled(!DifferencesDialog.this.toHeadButton.getSelection());
                DifferencesDialog.this.setOkButtonStatus();
                if (e.getSource() == DifferencesDialog.this.fromHeadButton && !DifferencesDialog.this.fromHeadButton.getSelection()) {
                    DifferencesDialog.this.fromRevisionText.selectAll();
                    DifferencesDialog.this.fromRevisionText.setFocus();
                }
                if (e.getSource() == DifferencesDialog.this.toHeadButton && !DifferencesDialog.this.toHeadButton.getSelection()) {
                    DifferencesDialog.this.toRevisionText.selectAll();
                    DifferencesDialog.this.toRevisionText.setFocus();
                }
            }
        };
        SelectionAdapter compareTypeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DifferencesDialog.this.diffButton.getSelection()) {
                    DifferencesDialog.this.fileText.setEnabled(true);
                    DifferencesDialog.this.browseButton.setEnabled(true);
                    DifferencesDialog.this.fileText.selectAll();
                    DifferencesDialog.this.fileText.setFocus();
                } else {
                    DifferencesDialog.this.fileText.setEnabled(false);
                    DifferencesDialog.this.browseButton.setEnabled(false);
                }
                DifferencesDialog.this.setOkButtonStatus();
            }
        };
        this.fileText.addModifyListener(modifyListener);
        this.fromRevisionText.addModifyListener(modifyListener);
        this.toRevisionText.addModifyListener(modifyListener);
        this.fromHeadButton.addSelectionListener((SelectionListener)selectionListener);
        this.toHeadButton.addSelectionListener((SelectionListener)selectionListener);
        this.compareButton.addSelectionListener((SelectionListener)compareTypeListener);
        this.diffButton.addSelectionListener((SelectionListener)compareTypeListener);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.fromRevisionText.addFocusListener((FocusListener)focusListener);
        this.toRevisionText.addFocusListener((FocusListener)focusListener);
        this.fileText.addFocusListener((FocusListener)focusListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.show_unified_diff_dialog_context");
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button toggleFromToButton = this.createButton(parent, 2, Policy.bind("ShowDifferencesAsUnifiedDiffDialog.swap"), false);
        toggleFromToButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fromUrl = DifferencesDialog.this.fromUrlText.getText().trim();
                boolean fromHeadRevision = DifferencesDialog.this.fromHeadButton.getSelection();
                String fromRevision = DifferencesDialog.this.fromRevisionText.getText().trim();
                String toUrl = DifferencesDialog.this.toUrlText.getText().trim();
                boolean toHeadRevision = DifferencesDialog.this.toHeadButton.getSelection();
                String toRevision = DifferencesDialog.this.toRevisionText.getText().trim();
                DifferencesDialog.this.fromUrlText.setText(toUrl);
                DifferencesDialog.this.toUrlText.setText(fromUrl);
                if (toHeadRevision) {
                    DifferencesDialog.this.fromHeadButton.setSelection(true);
                } else {
                    DifferencesDialog.this.fromHeadButton.setSelection(false);
                }
                if (fromHeadRevision) {
                    DifferencesDialog.this.toHeadButton.setSelection(true);
                } else {
                    DifferencesDialog.this.toHeadButton.setSelection(false);
                }
                DifferencesDialog.this.fromRevisionText.setText(toRevision);
                DifferencesDialog.this.toRevisionText.setText(fromRevision);
                if (DifferencesDialog.this.fromResource == DifferencesDialog.this.remoteResources[0]) {
                    DifferencesDialog.this.fromResource = DifferencesDialog.this.remoteResources[1];
                } else {
                    DifferencesDialog.this.fromResource = DifferencesDialog.this.remoteResources[0];
                }
                DifferencesDialog.this.fromRevisionText.setEnabled(!DifferencesDialog.this.fromHeadButton.getSelection());
                DifferencesDialog.this.toRevisionText.setEnabled(!DifferencesDialog.this.toHeadButton.getSelection());
                DifferencesDialog.this.setOkButtonStatus();
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
        }
        return button;
    }

    protected void okPressed() {
        this.success = true;
        if (this.diffButton.getSelection()) {
            this.diff();
        }
        if (this.compareButton.getSelection()) {
            this.compare();
        }
        if (!this.success) {
            return;
        }
        super.okPressed();
    }

    private void diff() {
        final File file = new File(this.fileText.getText().trim());
        if (file.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("HistoryView.showDifferences"), (String)Policy.bind("HistoryView.overwriteOutfile", file.getName()))) {
            return;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    SVNRevision toRevision;
                    SVNRevision fromRevision;
                    SVNUrl fromUrl = null;
                    SVNUrl toUrl = null;
                    if (DifferencesDialog.this.fromHeadButton.getSelection()) {
                        fromRevision = SVNRevision.HEAD;
                    } else {
                        int fromRevisionInt = Integer.parseInt(DifferencesDialog.this.fromRevisionText.getText().trim());
                        long fromRevisionLong = fromRevisionInt;
                        fromRevision = new SVNRevision.Number(fromRevisionLong);
                    }
                    if (DifferencesDialog.this.toHeadButton.getSelection()) {
                        toRevision = SVNRevision.HEAD;
                    } else {
                        int toRevisionInt = Integer.parseInt(DifferencesDialog.this.toRevisionText.getText().trim());
                        long toRevisionLong = toRevisionInt;
                        toRevision = new SVNRevision.Number(toRevisionLong);
                    }
                    fromUrl = new SVNUrl(DifferencesDialog.this.fromUrlText.getText().trim());
                    toUrl = new SVNUrl(DifferencesDialog.this.toUrlText.getText().trim());
                    ShowDifferencesAsUnifiedDiffOperation operation = new ShowDifferencesAsUnifiedDiffOperation(DifferencesDialog.this.targetPart, fromUrl, fromRevision, toUrl, toRevision, file);
                    operation.setLocalResource(DifferencesDialog.this.remoteResources[0]);
                    operation.run();
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)DifferencesDialog.this.getShell(), (String)Policy.bind("HistoryView.showDifferences"), (String)e.getMessage());
                    DifferencesDialog.this.success = false;
                }
            }
        });
    }

    private void compare() {
        if (this.fromResource instanceof ISVNRemoteResource && this.toResource != null && this.toResource instanceof ISVNRemoteResource) {
            SVNRevision toRevision;
            SVNRevision fromRevision;
            SVNUrl fromUrl = null;
            SVNUrl toUrl = null;
            if (this.fromHeadButton.getSelection()) {
                fromRevision = SVNRevision.HEAD;
            } else {
                int fromRevisionInt = Integer.parseInt(this.fromRevisionText.getText().trim());
                long fromRevisionLong = fromRevisionInt;
                fromRevision = new SVNRevision.Number(fromRevisionLong);
            }
            if (this.toHeadButton.getSelection()) {
                toRevision = SVNRevision.HEAD;
            } else {
                int toRevisionInt = Integer.parseInt(this.toRevisionText.getText().trim());
                long toRevisionLong = toRevisionInt;
                toRevision = new SVNRevision.Number(toRevisionLong);
            }
            try {
                fromUrl = new SVNUrl(this.fromUrlText.getText().trim());
                toUrl = new SVNUrl(this.toUrlText.getText().trim());
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("DifferencesDialog.compare"), (String)e.getMessage());
                this.success = false;
                return;
            }
            Object resource1 = null;
            SVNRevision.Number lastChangedRevision1 = null;
            Object resource2 = null;
            SVNRevision.Number lastChangedRevision2 = null;
            lastChangedRevision1 = fromRevision instanceof SVNRevision.Number ? (SVNRevision.Number)fromRevision : ((ISVNRemoteResource)this.remoteResources[0]).getLastChangedRevision();
            resource1 = this.fromResource.isFolder() ? new RemoteFolder(null, this.fromResource.getRepository(), fromUrl, fromRevision, lastChangedRevision1, null, null) : new RemoteFile(null, this.fromResource.getRepository(), fromUrl, fromRevision, lastChangedRevision1, null, null);
            if (fromRevision instanceof SVNRevision.Number && this.usePegRevision && resource1 instanceof RemoteResource) {
                ((RemoteResource)resource1).setPegRevision(fromRevision);
            }
            lastChangedRevision2 = toRevision instanceof SVNRevision.Number ? (SVNRevision.Number)toRevision : ((ISVNRemoteResource)this.remoteResources[1]).getLastChangedRevision();
            resource2 = this.toResource.isFolder() ? new RemoteFolder(null, this.toResource.getRepository(), toUrl, toRevision, lastChangedRevision2, null, null) : new RemoteFile(null, this.toResource.getRepository(), toUrl, toRevision, lastChangedRevision2, null, null);
            if (toRevision instanceof SVNRevision.Number && this.usePegRevision && resource2 instanceof RemoteResource) {
                ((RemoteResource)resource2).setPegRevision(toRevision);
            }
            ISVNRemoteResource[] remotes = new ISVNRemoteResource[]{resource1, resource2};
            CompareRemoteResourcesAction compareAction = new CompareRemoteResourcesAction();
            compareAction.setRemoteResources(remotes);
            compareAction.setLocalResources(this.remoteResources);
            try {
                compareAction.execute(null);
            }
            catch (InvocationTargetException e) {
                SVNUIPlugin.log(4, e.getMessage(), e);
            }
            catch (InterruptedException e) {
                SVNUIPlugin.log(4, e.getMessage(), e);
            }
        }
    }

    private void setOkButtonStatus() {
        boolean canFinish = true;
        if (this.diffButton.getSelection() && this.fileText.getText().trim().length() == 0) {
            canFinish = false;
        }
        if (!this.fromHeadButton.getSelection() && this.fromRevisionText.getText().trim().length() == 0) {
            canFinish = false;
        }
        if (!this.toHeadButton.getSelection() && this.toRevisionText.getText().trim().length() == 0) {
            canFinish = false;
        }
        this.okButton.setEnabled(canFinish);
    }

    private void showLog(Object sourceButton) {
        HistoryDialog dialog = null;
        if (sourceButton == this.fromLogButton) {
            dialog = this.fromResource instanceof ISVNRemoteResource ? (this.fromResource == this.remoteResources[0] ? new HistoryDialog(this.getShell(), (ISVNRemoteResource)this.remoteResources[0]) : new HistoryDialog(this.getShell(), (ISVNRemoteResource)this.remoteResources[1])) : (this.fromResource == this.remoteResources[0] ? new HistoryDialog(this.getShell(), this.remoteResources[0].getResource()) : new HistoryDialog(this.getShell(), this.remoteResources[1].getResource()));
            if (dialog.open() == 1) {
                return;
            }
            ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
            if (selectedEntries.length == 0) {
                return;
            }
            this.fromRevisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        } else {
            dialog = this.fromResource instanceof ISVNRemoteResource ? (this.fromResource == this.remoteResources[0] ? new HistoryDialog(this.getShell(), (ISVNRemoteResource)this.remoteResources[1]) : new HistoryDialog(this.getShell(), (ISVNRemoteResource)this.remoteResources[0])) : (this.fromResource == this.remoteResources[0] ? new HistoryDialog(this.getShell(), this.remoteResources[1].getResource()) : new HistoryDialog(this.getShell(), ((ISVNRemoteResource)this.remoteResources[0]).getResource()));
            if (dialog.open() == 1) {
                return;
            }
            ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
            if (selectedEntries.length == 0) {
                return;
            }
            this.toRevisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        }
        this.setOkButtonStatus();
    }

    public void setFromRevision(String fromRevision) {
        this.fromRevision = fromRevision;
    }

    public void setToRevision(String toRevision) {
        this.toRevision = toRevision;
    }

    public void setUsePegRevision(boolean usePegRevision) {
        this.usePegRevision = usePegRevision;
    }
}

