/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.properties;

import java.net.MalformedURLException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.repo.SVNRepositories;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.decorator.SVNLightweightDecorator;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseRootUrlDialog;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNRepositoryPropertiesPage
extends PropertyPage {
    private ISVNRepositoryLocation location;
    private static final String FAKE_PASSWORD = "*********";
    private Text loginText;
    private Text passwordText;
    private Text customLabelText;
    private Button useUrlLabelButton;
    private Button useCustomLabelButton;
    private boolean passwordChanged;
    private Text repositoryRootText;
    private Text repositoryUrlText;
    private boolean showCredentials;
    private static final String COMMANDLINE_CLIENT = "commandline";
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.initialize();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                SVNRepositoryPropertiesPage.this.updateWidgetEnablements();
            }
        };
        Composite labelGroup = new Composite(composite, 0);
        labelGroup.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.numColumns = 2;
        labelGroup.setLayout((Layout)layout);
        this.useUrlLabelButton = new Button(labelGroup, 16);
        this.useUrlLabelButton.setText(Policy.bind("SVNRepositoryPropertiesPage.useRepositoryUrlAsLabel"));
        this.useUrlLabelButton.addListener(13, labelListener);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.useUrlLabelButton.setLayoutData((Object)data);
        this.useCustomLabelButton = new Button(labelGroup, 16);
        this.useCustomLabelButton.setText(Policy.bind("SVNRepositoryPropertiesPage.useCustomLabel"));
        this.useCustomLabelButton.addListener(13, labelListener);
        data = new GridData();
        this.useCustomLabelButton.setLayoutData((Object)data);
        this.customLabelText = new Text(labelGroup, 2052);
        this.customLabelText.addListener(24, labelListener);
        data = new GridData(768);
        this.customLabelText.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.customLabelText.addFocusListener((FocusListener)focusListener);
        if (this.showCredentials) {
            Composite userPasswordGroup = new Composite(composite, 0);
            userPasswordGroup.setLayoutData((Object)new GridData(768));
            layout = new GridLayout();
            layout.numColumns = 2;
            userPasswordGroup.setLayout((Layout)layout);
            label = new Label(userPasswordGroup, 0);
            label.setText(Policy.bind("SVNRepositoryPropertiesPage.login"));
            this.loginText = new Text(userPasswordGroup, 2052);
            data = new GridData(768);
            data.grabExcessHorizontalSpace = true;
            this.loginText.setLayoutData((Object)data);
            this.loginText.addFocusListener((FocusListener)focusListener);
            label = new Label(userPasswordGroup, 0);
            label.setText(Policy.bind("SVNRepositoryPropertiesPage.password"));
            this.passwordText = new Text(userPasswordGroup, 0x400804);
            data = new GridData(768);
            data.grabExcessHorizontalSpace = true;
            this.passwordText.setLayoutData((Object)data);
            this.passwordText.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    SVNRepositoryPropertiesPage.this.passwordChanged = !SVNRepositoryPropertiesPage.this.passwordText.getText().equals(SVNRepositoryPropertiesPage.FAKE_PASSWORD);
                }
            });
            this.passwordText.addFocusListener((FocusListener)focusListener);
        }
        label = new Label(composite, 0);
        Composite repositoryRootGroup = new Composite(composite, 0);
        repositoryRootGroup.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.numColumns = 3;
        repositoryRootGroup.setLayout((Layout)layout);
        label = new Label(repositoryRootGroup, 0);
        label.setText(Policy.bind("SVNRepositoryPropertiesPage.repositoryUrl"));
        this.repositoryUrlText = new Text(repositoryRootGroup, 4);
        this.repositoryUrlText.setText("");
        this.repositoryUrlText.setEditable(false);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        this.repositoryUrlText.setLayoutData((Object)data);
        label = new Label(repositoryRootGroup, 0);
        label.setText(Policy.bind("SVNRepositoryPropertiesPage.repositoryRootUrl"));
        this.repositoryRootText = new Text(repositoryRootGroup, 2052);
        this.repositoryRootText.setEditable(false);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.repositoryRootText.setLayoutData((Object)data);
        Button button = new Button(repositoryRootGroup, 0);
        button.setText(Policy.bind("SVNRepositoryPropertiesPage.browseRootUrl"));
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SVNRepositoryPropertiesPage.this.openChooseRootDialog();
            }
        });
        Composite warningComposite = new Composite(composite, 0);
        warningComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginHeight = 0;
        warningComposite.setLayout((Layout)layout);
        Label warningLabel = new Label(warningComposite, 0);
        warningLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        warningLabel.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
        Label warningText = new Label(warningComposite, 64);
        warningText.setLayoutData((Object)new GridData(4, 128, true, false));
        warningText.setText(Policy.bind("SVNRepositoryPropertiesPage.rootUrlWarning"));
        this.initializeValues();
        return composite;
    }

    private void openChooseRootDialog() {
        ChooseRootUrlDialog dialog = new ChooseRootUrlDialog(this.getShell(), this.location.getUrl());
        if (dialog.open() == 0) {
            SVNUrl url = dialog.getRootUrl();
            if (url == null) {
                this.repositoryRootText.setText("");
            } else {
                this.repositoryRootText.setText(dialog.getRootUrl().toString());
            }
        }
    }

    protected void updateWidgetEnablements() {
        if (this.useUrlLabelButton.getSelection()) {
            this.customLabelText.setEnabled(false);
        } else {
            this.customLabelText.setEnabled(true);
        }
        this.validateFields();
    }

    private void validateFields() {
        if (this.customLabelText.isEnabled() && this.customLabelText.getText().length() == 0) {
            this.setValid(false);
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }

    private void initializeValues() {
        String label;
        this.passwordChanged = false;
        if (this.showCredentials) {
            this.loginText.setText(this.location.getUsername());
            this.passwordText.setText(FAKE_PASSWORD);
        }
        this.useUrlLabelButton.setSelection((label = this.location.getLabel()) == null);
        this.useCustomLabelButton.setSelection(!this.useUrlLabelButton.getSelection());
        if (label == null) {
            label = this.location.getLocation();
        }
        this.customLabelText.setText(label);
        SVNUrl url = this.location.getUrl();
        if (url != null) {
            this.repositoryUrlText.setText(url.toString());
        } else {
            this.repositoryUrlText.setText("");
        }
        SVNUrl repositoryRoot = this.location.getRepositoryRoot();
        if (repositoryRoot != null) {
            this.repositoryRootText.setText(repositoryRoot.toString());
        } else {
            this.repositoryRootText.setText("");
        }
    }

    private void initialize() {
        this.location = null;
        IAdaptable element = this.getElement();
        if (element instanceof ISVNRepositoryLocation) {
            this.location = (ISVNRepositoryLocation)element;
        } else {
            Object adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.tigris.subversion.subclipse.core.ISVNRepositoryLocation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = element.getAdapter((Class)clazz)) instanceof ISVNRepositoryLocation) {
                this.location = (ISVNRepositoryLocation)adapter;
            }
        }
        this.showCredentials = SVNProviderPlugin.getPlugin().getSVNClientManager().getSvnClientInterface().equals(COMMANDLINE_CLIENT);
        if (!this.showCredentials && this.location.getUsername() != null && !this.location.getUsername().trim().equals("")) {
            this.showCredentials = true;
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeValues();
    }

    public boolean performOk() {
        if (this.showCredentials) {
            if (this.passwordChanged) {
                this.location.setPassword(this.passwordText.getText());
                this.passwordChanged = false;
            }
            this.location.setUsername(this.loginText.getText());
        }
        if (this.useCustomLabelButton.getSelection()) {
            this.location.setLabel(this.customLabelText.getText());
        } else {
            this.location.setLabel(null);
        }
        if (!this.repositoryRootText.getText().equals("")) {
            try {
                this.location.setRepositoryRoot(new SVNUrl(this.repositoryRootText.getText()));
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            this.location.setRepositoryRoot(null);
        }
        try {
            SVNRepositories repositories = SVNProviderPlugin.getPlugin().getRepositories();
            repositories.addOrUpdateRepository(this.location);
            SVNLightweightDecorator.refresh();
        }
        catch (SVNException e) {
            this.handle(e);
            return false;
        }
        return true;
    }

    protected void handle(Throwable e) {
        SVNUIPlugin.openError(this.getShell(), null, null, e);
    }
}

