/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.DebugTargetEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.EventHandlerModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.StackFrameEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.ThreadEventHandler;
import org.eclipse.jface.viewers.Viewer;

public class DebugTargetProxy
extends EventHandlerModelProxy {
    private IDebugTarget fDebugTarget;

    public DebugTargetProxy(IDebugTarget target) {
        this.fDebugTarget = target;
    }

    public synchronized void dispose() {
        super.dispose();
        this.fDebugTarget = null;
    }

    protected boolean containsEvent(DebugEvent event) {
        IDebugTarget debugTarget;
        Object source = event.getSource();
        if (source instanceof IDebugElement && (debugTarget = ((IDebugElement)source).getDebugTarget()) != null) {
            return debugTarget.equals(this.fDebugTarget);
        }
        return false;
    }

    protected DebugEventHandler[] createEventHandlers() {
        ThreadEventHandler threadEventHandler = new ThreadEventHandler(this);
        return new DebugEventHandler[]{new DebugTargetEventHandler(this), threadEventHandler, new StackFrameEventHandler(this, threadEventHandler)};
    }

    public void installed(Viewer viewer) {
        IDebugTarget target = this.fDebugTarget;
        if (target != null) {
            try {
                IStackFrame frame;
                IThread[] threads = target.getThreads();
                ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                ILaunch launch = target.getLaunch();
                int launchIndex = this.indexOf(manager.getLaunches(), target.getLaunch());
                int targetIndex = this.indexOf(target.getLaunch().getChildren(), target);
                IThread chosen = null;
                int threadIndex = -1;
                int i = 0;
                while (i < threads.length) {
                    IThread thread = threads[i];
                    if (thread.isSuspended()) {
                        IBreakpoint[] bps = thread.getBreakpoints();
                        if (bps != null && bps.length > 0) {
                            chosen = thread;
                            threadIndex = i;
                            break;
                        }
                        if (chosen == null) {
                            chosen = thread;
                            threadIndex = i;
                        }
                    }
                    ++i;
                }
                if (chosen != null && (frame = chosen.getTopStackFrame()) != null) {
                    ModelDelta delta = new ModelDelta(manager, 0);
                    ModelDelta node = delta.addNode(launch, launchIndex, 0, target.getLaunch().getChildren().length);
                    node = node.addNode(target, targetIndex, 0, threads.length);
                    node = node.addNode(chosen, threadIndex, 0x100000, chosen.getStackFrames().length);
                    node = node.addNode(frame, 0, 0x200000, 0);
                    this.fireModelChanged(delta);
                    return;
                }
                ModelDelta delta = new ModelDelta(manager, 0);
                ModelDelta node = delta.addNode(launch, launchIndex, 0, target.getLaunch().getChildren().length);
                node = node.addNode(target, targetIndex, 0x300000, threads.length);
                this.fireModelChanged(delta);
            }
            catch (DebugException debugException) {}
        }
    }
}

