/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense;

import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.wordnet.core.rep.sense.ISynsetAnalysis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynsetAnalysis
implements ISynsetAnalysis {
    private final List<IBaseWordInfo> synonyms;
    private final List<IBaseWordInfo> full;
    private final List<IBaseWordInfo> open;

    public SynsetAnalysis(List<IBaseWordInfo> analysis, IBaseWordInfo ... synonyms) {
        if (synonyms.length == 0) {
            throw new IllegalArgumentException();
        }
        if (analysis.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.synonyms = Collections.unmodifiableList(Arrays.asList(synonyms));
        this.full = Collections.unmodifiableList(new ArrayList<IBaseWordInfo>(analysis));
        this.open = SynsetAnalysis.extractOpenInformation(this.full);
    }

    @Override
    public List<IBaseWordInfo> getSynonyms() {
        return this.synonyms;
    }

    @Override
    public List<IBaseWordInfo> getFullAnalysis() {
        return this.full;
    }

    @Override
    public List<IBaseWordInfo> getOpenAnalysis() {
        return this.open;
    }

    public static List<IBaseWordInfo> extractOpenInformation(List<IBaseWordInfo> full) {
        ArrayList<IBaseWordInfo> list = new ArrayList<IBaseWordInfo>(full.size());
        for (IBaseWordInfo info : full) {
            if (!info.isSenseTaggable()) continue;
            list.add(info);
        }
        list.trimToSize();
        return Collections.unmodifiableList(list);
    }
}

