/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.changes;

import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.factory.FactoryManager;
import edu.mit.story.core.desc.factory.IFactoryDescriptor;
import edu.mit.story.core.desc.factory.IFactoryManager;
import edu.mit.story.core.descriptor.Descriptor;
import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddRepsWithConfigChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.RemoveMetadataChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.property.Configuration;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IRepConfiguration;
import edu.mit.story.core.property.RepConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;

public class GenerateSenseModelChange
extends AbstractModelChange {
    public GenerateSenseModelChange() {
        super("Create Sense Annotation Group Story");
    }

    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        HashSet<IRep> exactReps = new HashSet<IRep>(Arrays.asList(CharRep.getInstance(), TextRep.getInstance(), TokenRep.getInstance(), SentenceRep.getInstance()));
        if (!exactReps.equals(model.getSupported())) {
            throw new IllegalArgumentException();
        }
        IFactoryManager factMan = StoryPlugin.getDefault().getFactoryManager();
        LinkedList<IRep> reps = new LinkedList<IRep>();
        LinkedList configs = new LinkedList();
        RepConfiguration factConfigs = new RepConfiguration((IDescriptor)new Descriptor("factories", "Factory Configurations", null));
        IRep rep = CollocRep.getInstance();
        reps.add(rep);
        IFactoryDescriptor factDesc = (IFactoryDescriptor)factMan.getDescriptor(FactoryManager.makeDefaultFactoryID((IRep)rep));
        factConfigs.put((Object)rep.getID(), (Object)factDesc.getID());
        rep = POSRep.getInstance();
        reps.add(rep);
        factDesc = (IFactoryDescriptor)factMan.getDescriptor(FactoryManager.makeDefaultFactoryID((IRep)rep));
        factConfigs.put((Object)rep.getID(), (Object)factDesc.getID());
        Configuration factConfig = new Configuration(factDesc.getConfigurationDescriptor());
        factConfig.put((Object)"tagger", (Object)"edu.stanford.parser.postagger.leftthree");
        factConfigs.putRepConfiguration(rep, (IConfiguration)factConfig);
        rep = StemRep.getInstance();
        reps.add(rep);
        factDesc = (IFactoryDescriptor)factMan.getDescriptor(FactoryManager.makeDefaultFactoryID((IRep)rep));
        factConfigs.put((Object)rep.getID(), (Object)factDesc.getID());
        factConfig = new Configuration(factDesc.getConfigurationDescriptor());
        factConfig.put((Object)"stemmer", (Object)"edu.mit.wordnet.stemmer.wordnet");
        factConfigs.putRepConfiguration(rep, (IConfiguration)factConfig);
        rep = SenseRep.getInstance();
        reps.add(rep);
        Configuration repConfig = new Configuration(SenseRep.getInstance().getConfigurationDescriptor());
        repConfig.put((Object)"wordnet", (Object)"edu.princeton.wordnet.30");
        factDesc = (IFactoryDescriptor)factMan.getDescriptor(FactoryManager.makeDefaultFactoryID((IRep)rep));
        factConfigs.put((Object)rep.getID(), (Object)factDesc.getID());
        factConfig = new Configuration(factDesc.getConfigurationDescriptor());
        factConfig.put((Object)"senseTagger", (Object)"edu.mit.wordnet.senseTagger.flat");
        factConfigs.putRepConfiguration(rep, (IConfiguration)factConfig);
        LinkedList<Object> changes = new LinkedList<Object>();
        changes.add(new AddRepsWithConfigChange(reps, configs, (IRepConfiguration)factConfigs));
        changes.add(new RemoveMetadataChange());
        return new CompositeModelChange(changes).apply(source, model);
    }
}

