/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.directorywatcher;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.generator.features.FeatureParser;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.repository.RepositoryEvent;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.Activator;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.Messages;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.BundleDescriptionFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.Feature;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.MetadataGeneratorHelper;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.URLEntry;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class RepositoryListener
extends DirectoryChangeListener {
    private static final String ARTIFACT_FOLDER = "artifact.folder";
    private static final String ARTIFACT_REFERENCE = "artifact.reference";
    private static final String FILE_LAST_MODIFIED = "file.lastModified";
    private static final String FILE_NAME = "file.name";
    private final IMetadataRepository metadataRepository;
    private final IArtifactRepository artifactRepository;
    private final BundleDescriptionFactory bundleDescriptionFactory;
    private final Map currentFiles = new HashMap();
    private Collection polledSeenFiles = new HashSet();
    private Collection polledIUsToAdd = new ArrayList();
    private Collection polledArtifactsToAdd = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public RepositoryListener(BundleContext context, String repositoryName, File repositoryFolder, boolean hidden) {
        URL stateDirURL;
        File stateDir;
        if (repositoryFolder == null) {
            String stateDirName = "listener_" + repositoryName.hashCode();
            stateDir = context.getDataFile(stateDirName);
            stateDir.mkdirs();
        } else {
            stateDir = repositoryFolder;
        }
        try {
            stateDirURL = stateDir.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
        this.metadataRepository = this.initializeMetadataRepository(context, repositoryName, stateDirURL, hidden);
        this.artifactRepository = this.initializeArtifactRepository(context, repositoryName, stateDirURL, hidden);
        this.bundleDescriptionFactory = this.initializeBundleDescriptionFactory(context);
        this.synchronizeCurrentFiles();
    }

    public RepositoryListener(BundleContext context, IMetadataRepository metadataRepository, IArtifactRepository artifactRepository) {
        this.artifactRepository = artifactRepository;
        this.metadataRepository = metadataRepository;
        this.bundleDescriptionFactory = this.initializeBundleDescriptionFactory(context);
        this.synchronizeCurrentFiles();
    }

    private void publishSites(Feature feature) {
        IProvisioningEventBus bus = (IProvisioningEventBus)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProvisioningEventBus.SERVICE_NAME);
        if (bus == null) {
            return;
        }
        URLEntry[] discoverySites = feature.getDiscoverySites();
        int i = 0;
        while (i < discoverySites.length) {
            this.publishSite(feature, bus, discoverySites[i].getURL(), false);
            ++i;
        }
        String updateSite = feature.getUpdateSiteURL();
        if (updateSite != null) {
            this.publishSite(feature, bus, updateSite, true);
        }
    }

    private void publishSite(Feature feature, IProvisioningEventBus bus, String locationString, boolean isEnabled) {
        try {
            URL location = new URL(locationString);
            bus.publishEvent((EventObject)new RepositoryEvent(location, 0, 4, isEnabled));
            bus.publishEvent((EventObject)new RepositoryEvent(location, 1, 4, isEnabled));
        }
        catch (MalformedURLException e) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.directorywatcher", "Feature references invalid site: " + feature.getId(), (Throwable)e));
        }
    }

    private BundleDescriptionFactory initializeBundleDescriptionFactory(BundleContext context) {
        ServiceReference reference;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reference = context.getServiceReference(clazz.getName())) == null) {
            throw new IllegalStateException(Messages.platformadmin_not_registered);
        }
        PlatformAdmin platformAdmin = (PlatformAdmin)context.getService(reference);
        if (platformAdmin == null) {
            throw new IllegalStateException(Messages.platformadmin_not_registered);
        }
        try {
            StateObjectFactory stateObjectFactory = platformAdmin.getFactory();
            BundleDescriptionFactory bundleDescriptionFactory = new BundleDescriptionFactory(stateObjectFactory, null);
            return bundleDescriptionFactory;
        }
        finally {
            context.ungetService(reference);
        }
    }

    private IArtifactRepository initializeArtifactRepository(BundleContext context, String repositoryName, URL stateDirURL, boolean hidden) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        IArtifactRepositoryManager manager = null;
        if (reference != null) {
            manager = (IArtifactRepositoryManager)context.getService(reference);
        }
        if (manager == null) {
            throw new IllegalStateException(Messages.artifact_repo_manager_not_registered);
        }
        try {
            IArtifactRepository iArtifactRepository = manager.loadRepository(stateDirURL, null);
            return iArtifactRepository;
        }
        catch (ProvisionException provisionException) {
            try {
                String name = repositoryName;
                HashMap<String, String> properties = new HashMap<String, String>(1);
                if (hidden) {
                    properties.put("p2.system", Boolean.TRUE.toString());
                    name = "artifact listener " + repositoryName;
                }
                IArtifactRepository iArtifactRepository = manager.createRepository(stateDirURL, name, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
                return iArtifactRepository;
            }
            catch (ProvisionException e) {
                LogHelper.log((ProvisionException)e);
                throw new IllegalStateException(NLS.bind((String)Messages.failed_create_artifact_repo, (Object)stateDirURL));
            }
        }
        finally {
            context.ungetService(reference);
        }
    }

    private IMetadataRepository initializeMetadataRepository(BundleContext context, String repositoryName, URL stateDirURL, boolean hidden) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        IMetadataRepositoryManager manager = null;
        if (reference != null) {
            manager = (IMetadataRepositoryManager)context.getService(reference);
        }
        if (manager == null) {
            throw new IllegalStateException(Messages.metadata_repo_manager_not_registered);
        }
        try {
            IMetadataRepository iMetadataRepository = manager.loadRepository(stateDirURL, null);
            return iMetadataRepository;
        }
        catch (ProvisionException provisionException) {
            String name = repositoryName;
            HashMap<String, String> properties = new HashMap<String, String>(1);
            if (hidden) {
                properties.put("p2.system", Boolean.TRUE.toString());
                name = "metadata listener " + repositoryName;
            }
            IMetadataRepository iMetadataRepository = manager.createRepository(stateDirURL, name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            return iMetadataRepository;
        }
        finally {
            context.ungetService(reference);
        }
    }

    public boolean added(File file) {
        return this.process(file);
    }

    public boolean changed(File file) {
        this.polledSeenFiles.remove(file);
        return this.process(file);
    }

    public boolean removed(File file) {
        return this.currentFiles.containsKey(file);
    }

    private boolean process(File file) {
        boolean isDirectory = file.isDirectory();
        if (isDirectory && file.getParentFile() != null && file.getParentFile().getName().equals("features") && new File(file, "feature.xml").exists()) {
            return this.processFeature(file);
        }
        if (isDirectory || file.getName().endsWith(".jar")) {
            return this.processBundle(file, isDirectory);
        }
        return false;
    }

    private boolean processBundle(File file, boolean isDirectory) {
        BundleDescription bundleDescription = this.bundleDescriptionFactory.getBundleDescription(file);
        if (bundleDescription == null) {
            return false;
        }
        String fileName = file.getAbsolutePath();
        String lastModified = Long.toString(file.lastModified());
        Properties props = new Properties();
        props.setProperty(FILE_NAME, fileName);
        props.setProperty(FILE_LAST_MODIFIED, lastModified);
        IArtifactKey key = MetadataGeneratorHelper.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IInstallableUnit[] ius = MetadataGeneratorHelper.createEclipseIU((BundleDescription)bundleDescription, (Map)((Map)bundleDescription.getUserObject()), (boolean)isDirectory, (IArtifactKey)key, (Properties)props);
        IInstallableUnit bundleIU = null;
        int i = 0;
        while (i < ius.length) {
            if (!ius[i].isFragment()) {
                bundleIU = ius[i];
                break;
            }
            ++i;
        }
        if (bundleIU == null) {
            if (ius.length == 0) {
                return false;
            }
            throw new IllegalStateException(Messages.multiple_bundle_ius);
        }
        this.polledIUsToAdd.add(bundleIU);
        ArtifactDescriptor descriptor = new ArtifactDescriptor(MetadataGeneratorHelper.createArtifactDescriptor((IArtifactKey)key, (File)file, (boolean)true, (boolean)false));
        try {
            descriptor.setRepositoryProperty(ARTIFACT_REFERENCE, file.toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        if (isDirectory) {
            descriptor.setRepositoryProperty(ARTIFACT_FOLDER, Boolean.TRUE.toString());
        }
        descriptor.setRepositoryProperty(FILE_NAME, fileName);
        descriptor.setRepositoryProperty(FILE_LAST_MODIFIED, lastModified);
        this.polledArtifactsToAdd.add(descriptor);
        return true;
    }

    private boolean processFeature(File file) {
        FeatureParser parser = new FeatureParser();
        Feature feature = parser.parse(file);
        if (feature == null) {
            return false;
        }
        this.publishSites(feature);
        String fileName = file.getAbsolutePath();
        String lastModified = Long.toString(file.lastModified());
        Properties props = new Properties();
        props.setProperty(FILE_NAME, fileName);
        props.setProperty(FILE_LAST_MODIFIED, lastModified);
        IInstallableUnit featureIU = MetadataGeneratorHelper.createFeatureJarIU((Feature)feature, (boolean)true, (Properties)props);
        IInstallableUnit groupIU = MetadataGeneratorHelper.createGroupIU((Feature)feature, (IInstallableUnit)featureIU, (Properties)props);
        this.polledIUsToAdd.add(featureIU);
        this.polledIUsToAdd.add(groupIU);
        IArtifactKey featureKey = MetadataGeneratorHelper.createFeatureArtifactKey((String)feature.getId(), (String)feature.getVersion());
        ArtifactDescriptor descriptor = new ArtifactDescriptor(featureKey);
        try {
            descriptor.setRepositoryProperty(ARTIFACT_REFERENCE, file.toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        descriptor.setRepositoryProperty(ARTIFACT_FOLDER, Boolean.TRUE.toString());
        descriptor.setRepositoryProperty(FILE_NAME, fileName);
        descriptor.setRepositoryProperty(FILE_LAST_MODIFIED, lastModified);
        this.polledArtifactsToAdd.add(descriptor);
        return true;
    }

    public boolean isInterested(File file) {
        return true;
    }

    public Long getSeenFile(File file) {
        Long lastSeen = (Long)this.currentFiles.get(file);
        if (lastSeen != null) {
            this.polledSeenFiles.add(file);
        }
        return lastSeen;
    }

    public void startPoll() {
    }

    public void stopPoll() {
        HashSet removedFiles = new HashSet(this.currentFiles.keySet());
        removedFiles.removeAll(this.polledSeenFiles);
        this.polledSeenFiles.clear();
        if (removedFiles.isEmpty() && this.polledIUsToAdd.isEmpty() && this.polledArtifactsToAdd.isEmpty()) {
            return;
        }
        if (this.metadataRepository != null) {
            this.synchronizeMetadataRepository(removedFiles);
        }
        if (this.artifactRepository != null) {
            this.synchronizeArtifactRepository(removedFiles);
        }
        this.synchronizeCurrentFiles();
        this.polledIUsToAdd.clear();
        this.polledArtifactsToAdd.clear();
    }

    private void synchronizeMetadataRepository(final Set removedFiles) {
        Query removeQuery = new Query(){

            public boolean isMatch(Object candidate) {
                if (!(candidate instanceof IInstallableUnit)) {
                    return false;
                }
                IInstallableUnit iu = (IInstallableUnit)candidate;
                File iuFile = new File(iu.getProperty(RepositoryListener.FILE_NAME));
                return removedFiles.contains(iuFile);
            }
        };
        this.metadataRepository.removeInstallableUnits(removeQuery, null);
        if (!this.polledIUsToAdd.isEmpty()) {
            this.metadataRepository.addInstallableUnits(this.polledIUsToAdd.toArray(new IInstallableUnit[this.polledIUsToAdd.size()]));
        }
    }

    private void synchronizeArtifactRepository(Set removedFiles) {
        ArrayList<IArtifactKey> keys = new ArrayList<IArtifactKey>(Arrays.asList(this.artifactRepository.getArtifactKeys()));
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            IArtifactKey key = (IArtifactKey)it.next();
            IArtifactDescriptor[] descriptors = this.artifactRepository.getArtifactDescriptors(key);
            int i = 0;
            while (i < descriptors.length) {
                ArtifactDescriptor descriptor = (ArtifactDescriptor)descriptors[i];
                File artifactFile = new File(descriptor.getRepositoryProperty(FILE_NAME));
                if (removedFiles.contains(artifactFile)) {
                    this.artifactRepository.removeDescriptor((IArtifactDescriptor)descriptor);
                }
                ++i;
            }
        }
        if (!this.polledArtifactsToAdd.isEmpty()) {
            this.artifactRepository.addDescriptors(this.polledArtifactsToAdd.toArray(new IArtifactDescriptor[this.polledArtifactsToAdd.size()]));
        }
    }

    private void synchronizeCurrentFiles() {
        Iterator it;
        this.currentFiles.clear();
        if (this.metadataRepository != null) {
            Collector ius = this.metadataRepository.query((Query)InstallableUnitQuery.ANY, new Collector(), null);
            it = ius.iterator();
            while (it.hasNext()) {
                IInstallableUnit iu = (IInstallableUnit)it.next();
                File iuFile = new File(iu.getProperty(FILE_NAME));
                Long iuLastModified = new Long(iu.getProperty(FILE_LAST_MODIFIED));
                this.currentFiles.put(iuFile, iuLastModified);
            }
        }
        if (this.artifactRepository != null) {
            ArrayList<IArtifactKey> keys = new ArrayList<IArtifactKey>(Arrays.asList(this.artifactRepository.getArtifactKeys()));
            it = keys.iterator();
            while (it.hasNext()) {
                IArtifactKey key = (IArtifactKey)it.next();
                IArtifactDescriptor[] descriptors = this.artifactRepository.getArtifactDescriptors(key);
                int i = 0;
                while (i < descriptors.length) {
                    ArtifactDescriptor descriptor = (ArtifactDescriptor)descriptors[i];
                    File artifactFile = new File(descriptor.getRepositoryProperty(FILE_NAME));
                    Long artifactLastModified = new Long(descriptor.getRepositoryProperty(FILE_LAST_MODIFIED));
                    this.currentFiles.put(artifactFile, artifactLastModified);
                    ++i;
                }
            }
        }
    }

    public IMetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    public IArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }
}

